<?php
session_start();

if (!isset($_SESSION['subscriber_logged_in']) || $_SESSION['dashboard_type'] !== 'basic') {
    header("Location: dashboard-basic.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>TPST Basic Dashboard</title>
    <link rel="stylesheet" href="../styles.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            background: linear-gradient(to right, #2c3e50, #34495e);
            color: white;
            text-align: center;
            padding: 60px 20px;
        }
        h1 {
            margin-bottom: 30px;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.7);
            color: white;
        }
        .panel {
            background: rgba(255,255,255,0.08);
            padding: 30px;
            border-radius: 10px;
            display: inline-block;
            box-shadow: 0 0 15px rgba(0,0,0,0.2);
        }
        .panel a, .panel button {
            display: block;
            margin: 12px auto;
            padding: 14px 22px;
            width: 280px;
            font-weight: bold;
            text-decoration: none;
            color: white;
            background-color: #2980b9;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            box-shadow: 0 2px 6px rgba(0,0,0,0.3);
            transition: background 0.3s;
        }
        .panel a:hover, .panel button:hover {
            background-color: #1f618d;
        }
        .copy-msg {
            margin-top: 10px;
            font-size: 0.9em;
            color: #2ecc71;
            display: none;
        }
    </style>
</head>
<body>

<h1>TPST Basic Dashboard</h1>

<div class="panel">
    <a href="book-test.php" target="_blank">📅 Schedule a Driving Test (Public Form)</a>
    <a href="view-weeks-appointments.php">🕵️ View Appointments</a>
    <a href="toggle-availability.php">🟢 Toggle Morning Availability</a>
    <a href="connect-google-calendar.php">🔗 Connect Google Calendar</a>

    <!-- Copy Scheduler URL -->
    <input type="hidden" id="schedulerURL" value="https://<?php echo $_SERVER['HTTP_HOST']; ?>/tpst/book-test.php">
    <button onclick="copySchedulerURL()">📋 Copy Scheduler URL</button>
    <div id="copyMsg" class="copy-msg">✅ URL copied to clipboard!</div>
    <a href="calendar-view.php" target="_blank">📆 View Public Calendar</a>

    <a href="subscriber-logout.php">🚪 Logout</a>
</div>
    

<script>
function copySchedulerURL() {
    const urlField = document.getElementById("schedulerURL");
    navigator.clipboard.writeText(urlField.value)
        .then(() => {
            const msg = document.getElementById("copyMsg");
            msg.style.display = 'block';
            setTimeout(() => msg.style.display = 'none', 2000);
        });
}
</script>

</body>
</html>

