<?php
session_start();
require_once 'includes/auth-check.php';

if ($_SESSION['dashboard_type'] !== 'pro') {
    header("Location: dashboard-basic.php");
    exit();
}

?>
<?php
session_start();

// Make sure the user is a logged-in subscriber with 'pro' tier
if (!isset($_SESSION['subscriber_logged_in']) || $_SESSION['dashboard_type'] !== 'pro') {
    header("Location: login-tpst.php");
    exit;
}

$subscriber_id = $_SESSION['subscriber_id'];
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <link rel="stylesheet" href="../styles.css">
    <meta charset="UTF-8">
    <title>Pro Dashboard</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: linear-gradient(to right, #2c3e50, #34495e);
            color: white;
            text-align: center;
            padding: 60px 20px;
        }
        h1 {
            margin-bottom: 30px;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.7);
        }
        .panel {
            background: rgba(255,255,255,0.1);
            padding: 30px;
            border-radius: 10px;
            display: inline-block;
            box-shadow: 0 0 15px rgba(0,0,0,0.2);
        }
        .panel a, .panel form button {
            display: block;
            margin: 12px auto;
            padding: 14px 22px;
            text-decoration: none;
            color: white;
            font-weight: bold;
            border-radius: 8px;
            background-color: #2980b9;
            box-shadow: 0 2px 6px rgba(0,0,0,0.3);
            transition: background 0.3s;
            width: 280px;
        }
        .panel a:hover, .panel form button:hover {
            background-color: #1f618d;
        }
    </style>
</head>
<body>
<h1>TPST Pro Dashboard</h1>
<div class="panel">
    <a href="book-test.php" target="_blank">📅 Schedule a Driving Test (Public Form)</a>
    <a href="view-weeks-appointments.php">🕵️ View & Manage Appointments</a>
    <a href="toggle-availability.php">🟢 Toggle Morning Availability</a>
    <a href="log-test-results.php">📝 Log Test Results</a>
    <a href="download-daily-uploads.php">📥 Download Daily Uploads</a>
    
    <!-- NEW BUTTONS BELOW -->
    <a href="connect-google-calendar.php">🔗 Connect Google Calendar</a>
        <!-- Copy Scheduler URL -->
    <input type="hidden" id="schedulerURL" value="https://<?php echo $_SERVER['HTTP_HOST']; ?>/tpst/book-test.php">
    <button onclick="copySchedulerURL()">📋 Copy Scheduler URL</button>
    <div id="copyMsg" class="copy-msg">✅ URL copied to clipboard!</div>
    <a href="calendar-view.php" target="_blank">📆 View Public Calendar</a>
    <a href="login-tpst.php">Logout</a>
</div>


<script>
function copySchedulerURL() {
    const urlField = document.getElementById("schedulerURL");
    navigator.clipboard.writeText(urlField.value)
        .then(() => {
            const msg = document.getElementById("copyMsg");
            msg.style.display = 'block';
            setTimeout(() => msg.style.display = 'none', 2000);
        });
}
</script>

</body>
</html>




