<?php
session_start();
require_once '../tpst/db.php';
require_once '../tpst/admin-login.php'; // Confirms admin session
require_once '../includes/verify-doc-access.php';

// Continue normal execution for allowed user

$log_id = isset($_GET['log_id']) ? intval($_GET['log_id']) : 0;
if ($log_id <= 0) {
    die("Invalid log ID.");
}

require 'db_tpst.php';

$stmt = $conn->prepare("SELECT appointment_id, test_date FROM TestLogs WHERE id = ?");
$stmt->bind_param("i", $log_id);
$stmt->execute();
$result = $stmt->get_result();
$log = $result->fetch_assoc();
$stmt->close();

if (!$log) {
    die("Log not found.");
}

$folder = "test-packets/" . date("Ymd", strtotime($log['test_date'])) . "-appt-{$log['appointment_id']}-log-{$log_id}/";

if (!is_dir($folder)) {
    die("Packet folder not found.");
}

$zipFile = sys_get_temp_dir() . "/packet-log-{$log_id}.zip";

$zip = new ZipArchive();
if ($zip->open($zipFile, ZipArchive::CREATE | ZipArchive::OVERWRITE) !== TRUE) {
    die("Could not create zip file.");
}

$files = scandir($folder);
foreach ($files as $file) {
    if (in_array($file, ['.', '..'])) continue;
    $zip->addFile($folder . $file, $file);
}
$zip->close();

// Force download
header('Content-Type: application/zip');
header("Content-Disposition: attachment; filename=\"TPST-Packet-{$log_id}.zip\"");
header('Content-Length: ' . filesize($zipFile));
readfile($zipFile);

// Cleanup
unlink($zipFile);
exit();
