<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require '../inludes/PHPMailer/PHPMailer.php';
require '../includes/PHPMailer/SMTP.php';
require '../includes/PHPMailer/Exception.php';

function sendChecklistEmail($email, $full_name, $test_date, $test_time, $price, $age_group) {
    $mail = new PHPMailer(true);

    try {
        // Server settings
        $mail->isSMTP();
        $mail->Host       = 'mail.tandddrivingacademy.com';
        $mail->SMTPAuth   = true;
        $mail->Username   = 'no-reply@tandddrivingacademy.com';
        $mail->Password   = '!ResetPassword1!';
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
        $mail->Port       = 465;

        // Recipients
        $mail->setFrom('no-reply@tandddrivingacademy.com', 'T&D Driving Academy');
        $mail->addAddress($email, $full_name);
        $mail->addBCC('info@tandddrivingacademy.com');

        // Content
        $mail->isHTML(true);
        $mail->Subject = "✅ Driving Test Scheduled – $test_date at $test_time";

        // Age-based checklist
        $checklist = "";
        switch ($age_group) {
            case "Under 18":
                $checklist = "<ul>
                    <li>Texas Learner Permit (plastic card)</li>
                    <li>DE-964 Certificate (green form, completed)</li>
                    <li>Parent/Guardian must be present</li>
                    <li>Impact Texas Teen Drivers (ITTD) Certificate</li>
                    <li>Corrective lenses if applicable</li>
                </ul>";
                break;
            case "18–24":
                $checklist = "<ul>
                    <li>Texas Learner Permit or Driver License</li>
                    <li>ADE-1317 Certificate of Completion</li>
                    <li>Impact Texas Young Drivers (ITYD) Certificate</li>
                    <li>Corrective lenses if applicable</li>
                </ul>";
                break;
            case "25+":
                $checklist = "<ul>
                    <li>Texas Learner Permit or Driver License</li>
                    <li>Impact Texas Adult Drivers (ITAD) Certificate</li>
                    <li>Corrective lenses if applicable</li>
                </ul>";
                break;
        }

        $mail->Body = "
            <p>Dear $full_name,</p>
            <p>Your driving test has been scheduled for <strong>$test_date at $test_time</strong>.</p>
            <p><strong>Total Due:</strong> \$$price (Due upon arrival)</p>
            <p>If you arrive after <strong>9:30 AM</strong>, an additional <strong>$25 late fee</strong> will be added.</p>
            <p>Please bring the following with you:</p>
            $checklist
            <p>If you have any questions, feel free to contact us.</p>
            <p>Thank you,<br>T&D Driving Academy</p>
        ";

        $mail->send();
    } catch (Exception $e) {
        error_log("Message could not be sent. Mailer Error: {$mail->ErrorInfo}");
    }
}
