<?php
require '../tpst/db.php'; // Adjust if needed

header('Content-Type: application/json');

$today = date("Y-m-d");
$stmt = $conn->prepare("SELECT date FROM TestDayAvailability WHERE is_available = 0 AND date >= ?");
$stmt->bind_param("s", $today);
$stmt->execute();
$result = $stmt->get_result();

$disabledDates = [];
while ($row = $result->fetch_assoc()) {
    $disabledDates[] = $row['date'];
}
$stmt->close();

echo json_encode($disabledDates);
