document.addEventListener('DOMContentLoaded', () => {
    const nameInput = document.getElementById('name_search');
    const suggestionBox = document.getElementById('name_suggestions');
    const hiddenId = document.getElementById('appointment_id');

    nameInput.addEventListener('input', () => {
        const query = nameInput.value.trim();
        suggestionBox.innerHTML = '';
        hiddenId.value = '';

        if (query.length < 2) {
            suggestionBox.style.display = 'none';
            return;
        }

        fetch('lookup-appointments.php?q=' + encodeURIComponent(query))
            .then(res => res.json())
            .then(data => {
                if (data.length > 0) {
                    suggestionBox.style.display = 'block';
                    data.forEach(item => {
                        const div = document.createElement('div');
                        div.textContent = `${item.full_name} – ${item.test_date}`;
                        div.style.padding = '6px 10px';
                        div.style.cursor = 'pointer';

                        div.onclick = () => {
                            nameInput.value = item.full_name;
                            hiddenId.value = item.id;
                            suggestionBox.innerHTML = '';
                            suggestionBox.style.display = 'none';
                        };

                        suggestionBox.appendChild(div);
                    });
                } else {
                    suggestionBox.style.display = 'none';
                }
            });
    });
});
