document.addEventListener("DOMContentLoaded", function () {
    const testDateInput = document.getElementById('test_date');

    if (!testDateInput) return;

    fetch('get-disabled-dates.php')
        .then(response => response.json())
        .then(disabledDates => {
            testDateInput.addEventListener('input', function () {
                const selectedDate = this.value;
                if (disabledDates.includes(selectedDate)) {
                    alert("That date is not available for scheduling. Please choose a different test day.");
                    this.value = '';
                }
            });

            // Optional: prevent weekend selection
            testDateInput.addEventListener('change', function () {
                const date = new Date(this.value);
                const day = date.getUTCDay();
                if (day === 0 || day === 6) {
                    alert("Please select a weekday (Monday–Friday).");
                    this.value = '';
                }
            });
        })
        .catch(error => {
            console.error("Failed to load disabled dates:", error);
        });
});
