<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require '../tpst/db.php';

require_once 'send_email_tpst.php';
require_once '../includes/PHPMailer/Exception.php';
require_once '../includes/PHPMailer/PHPMailer.php';
require_once '../includes/PHPMailer/SMTP.php';

// STEP 1: Gather POST data
$first_name = trim($_POST['first_name'] ?? '');
$last_name  = trim($_POST['last_name'] ?? '');
$email      = trim($_POST['email'] ?? '');
$phone      = trim($_POST['phone'] ?? '');
$dob        = trim($_POST['dob'] ?? '');
$test_date  = trim($_POST['test_date'] ?? '');

// Enforce scheduling window: allow only dates within next 14 days
$today = new DateTime();
$limit = new DateTime('+14 days');
$selected_date = DateTime::createFromFormat('Y-m-d', $test_date);

if (!$selected_date || $selected_date < $today || $selected_date > $limit) {
    echo "<script>alert('Appointments must be scheduled within the next 14 days.'); window.history.back();</script>";
    exit;
}

$test_time_raw = trim($_POST['test_time'] ?? '');
$test_time = date('H:i:s', strtotime($test_time_raw)); // force 24-hr format
$full_name  = "$first_name $last_name";
$age_group = ''; // ← This makes sure it's defined and helps debug if it stays empty.

// STEP 2: Validate required fields
if (empty($dob) || empty($test_date)) {
    echo "<script>alert('Missing date of birth or test date.'); window.history.back();</script>";
    exit;
}

// STEP 3: Check if applicant is at least 16 on test date
$birthdate = new DateTime($dob);
$test_day  = new DateTime($test_date);
$age_on_test_day = $birthdate->diff($test_day)->y;

if ($age_on_test_day < 16) {
    echo "<script>alert('You must be 16 years old on or before your test date to be eligible for a driving test.'); window.history.back();</script>";
    exit;
}

// ✅ STEP 3.5: Dynamically assign age group

if ($age_on_test_day < 18) {
    $age_group = 'under_18';
} elseif ($age_on_test_day <= 24) {
    $age_group = '18_24';
} else {
    $age_group = '25_plus';
}

// STEP 4: Determine price
$weekday = date('w', strtotime($test_date)); // 6 = Saturday
$is_saturday = ($weekday == 6);
$time_24hr = date('H:i', strtotime($test_time));
$is_after_930 = ($time_24hr > '09:30');
$price = ($is_saturday || $is_after_930) ? 125 : 100;


// Check if the selected date is marked as available
$stmt = $conn->prepare("SELECT is_available FROM TestDayAvailability WHERE date = ?");
$stmt->bind_param("s", $test_date);
$stmt->execute();
$stmt->bind_result($is_available);
$stmt->fetch();
$stmt->close();

if ($is_available !== 1) {
    // Block the booking
    echo "<script>alert('Sorry, that date is not available for testing. Please choose a different date.'); window.history.back();</script>";

    exit();
}

// STEP 4.5: Enforce morning appointment limit (before 10:00 AM)
$morning_cutoff = '10:00:00';

if ($test_time < $morning_cutoff) {
    $check_stmt = $conn->prepare("
        SELECT COUNT(*) 
        FROM TestAppointments 
        WHERE test_date = ? AND test_time < ?
    ");
    $check_stmt->bind_param("ss", $test_date, $morning_cutoff);
    $check_stmt->execute();
    $check_stmt->bind_result($morning_count);
    $check_stmt->fetch();
    $check_stmt->close();

    if ($morning_count >= 7) {
        echo "<script>alert('Sorry, all morning appointments (before 10:00 AM) are full for this date. Please choose a different time.'); window.history.back();</script>";
        exit;
    }
}

// STEP 5: Insert appointment
$stmt = $conn->prepare("INSERT INTO TestAppointments (first_name, last_name, email, phone, dob, test_date, test_time, price, age_group) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");

$stmt->bind_param("sssssssds", $first_name, $last_name, $email, $phone, $dob, $test_date, $test_time, $price, $age_group);

if ($stmt->execute()) {
    // ✅ STEP 5.5: Update age_group after insert
    $update_stmt = $conn->prepare("
        UPDATE TestAppointments
        SET age_group = CASE
            WHEN TIMESTAMPDIFF(YEAR, dob, test_date) < 18 THEN 'under_18'
            WHEN TIMESTAMPDIFF(YEAR, dob, test_date) BETWEEN 18 AND 24 THEN '18_24'
            ELSE '25_plus'
        END
        WHERE email = ? AND test_date = ?
    ");
    $update_stmt->bind_param("ss", $email, $test_date);
    $update_stmt->execute();
    $update_stmt->close();

    // STEP 6: Build checklist...

    // STEP 6: Build checklist
    $today = new DateTime();
    $age_now = $today->diff($birthdate)->y;

    if ($age_now < 18) {
        $checklist = "- Completed DE-964 certificate\n- Teen IMPACT Certificate (signed by student and parent)\n- Valid Permit (on or after 'hold until' date)";
    } elseif ($age_now >= 18 && $age_now <= 24) {
        $checklist = "- Completed ADE-1317 certificate\n- Adult IMPACT Certificate (signed)\n- Valid Permit";
    } else {
        $checklist = "- Adult IMPACT Certificate (signed)\n- Valid Permit";
    }

    // STEP 7: Validate and send email
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        error_log("Invalid email: $email");
        echo "❌ Invalid email address.";
        exit;
    }

    $subject = "Driving Test Appointment Pending";
    $html_body = "
        <p>Hello {$full_name},</p>
        <p>We have received your request for a driving test <strong>{$test_date}</strong> at <strong>{$test_time}</strong>.</p>
        <p>Your test fee is <strong>\${$price}</strong>. Please await a confirmation email with convenient document upload. If your schedule time is rejected, we'll reach out and accommodate another time.</p>
        <p>Required documents:</p><pre>{$checklist}</pre>";

    $plain_body = "
        <p>Hello {$full_name},</p>
        <p>We have received your request for a driving test <strong>{$test_date}</strong> at <strong>{$test_time}</strong>.</p>
        <p>Your test fee is <strong>\${$price}</strong>. Please await a confirmation email with convenient document upload. If your schedule time is rejected, we'll reach out and accommodate another time.</p>
        <p>Required documents:</p><pre>{$checklist}</pre>";

    if (send_email_tpst($email, $full_name, $subject, $html_body, $plain_body)) {
        echo "<script>alert('Thank you! Your appointment request has been received and is pending confirmation. A checklist has been emailed to {$email}.'); window.location.href='https://www.tandddrivingacademy.com/3rdpartyskillstest';</script>";

    } else {
        echo "❌ Email could not be sent. Please try again.";
    }

} else {
    echo "❌ Appointment could not be scheduled: " . $stmt->error;
}

$stmt->close();
$conn->close();
?>






