<?php
session_start();
require '../tpst/db.php';

$success = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email'] ?? '');
    $token = bin2hex(random_bytes(32));
    $expires = date('Y-m-d H:i:s', strtotime('+1 hour'));

    $stmt = $conn->prepare("SELECT sub_id FROM Subscribers WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows === 1) {
        $stmt->close();

        // Clean up any existing reset entries for this user
        $conn->prepare("DELETE FROM PasswordResets WHERE email = ? AND user_type = 'subscriber'")
             ->bind_param("s", $email)->execute();

        // Insert new reset token
        $stmt = $conn->prepare("INSERT INTO PasswordResets (email, user_type, token, expires_at) VALUES (?, 'subscriber', ?, ?)");
        $stmt->bind_param("sss", $email, $token, $expires);
        $stmt->execute();

        $reset_link = "https://tandddrivingacademy.com/tpst/subscriber-reset-password.php?token=$token";
        mail($email, "Reset Your Subscriber Password", "Click the link below to reset your password:\n\n$reset_link");

        $success = "✅ A reset link has been sent to your email.";
    } else {
        $error = "We could
