<?php
require '../tpst/db.php';

// Pull the next 30 weekday dates
$today = new DateTime();
$dates = [];

for ($i = 0; count($dates) < 30; $i++) {
    $candidate = (clone $today)->modify("+$i days");
    if (in_array($candidate->format('N'), [1,2,3,4,5,6]))
 {
        $dates[] = $candidate->format('Y-m-d');
    }
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $selected = isset($_POST['available']) ? $_POST['available'] : [];

    foreach ($dates as $date) {
        $is_available = in_array($date, $selected) ? 1 : 0;

        $stmt = $conn->prepare("
            INSERT INTO TestDayAvailability (date, is_available)
            VALUES (?, ?)
            ON DUPLICATE KEY UPDATE is_available = VALUES(is_available)
        ");
        $stmt->bind_param("si", $date, $is_available);
        $stmt->execute();
        $stmt->close();
    }
    header("Location: toggle-availability.php?saved=1");
    exit();
}

// Fetch current status
$availability = [];
$result = $conn->query("SELECT date, is_available FROM TestDayAvailability");
while ($row = $result->fetch_assoc()) {
    $availability[$row['date']] = $row['is_available'];
}
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Toggle Test Day Availability</title>
    <style>
    body {
        font-family: Arial;
        background: linear-gradient(to right, #bdc3c7, #2c3e50); /* light to dark steel-blue gradient */
        padding: 40px 20px;
        min-height: 100vh;
    }

    form {
        background: rgba(255, 255, 255, 0.85); /* semi-transparent white */
        padding: 20px;
        border-radius: 8px;
        box-shadow: 0 0 10px #ccc;
    }
        
    .grid-container {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
        gap: 10px;
    }

    .date-label {
        display: flex;
        align-items: center;
        background-color: #f9f9f9;
        padding: 8px 12px;
        border-radius: 6px;
        box-shadow: 0 1px 4px rgba(0,0,0,0.1);
        transition: background-color 0.2s ease;
    }

    .date-label:hover {
        background-color: #e0f7fa;
    }

    input[type="submit"] {
        margin-top: 20px;
        align-items: center;
        padding: 10px 20px;
        font-weight: bold;
        background-color: #3498db;
        border: none;
        color: white;
        border-radius: 6px;
        cursor: pointer;
    }

    h2 {
        color: white;
        text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.7);
}
    
</style>
</head>
<body>

<h2>Toggle Morning Test Availability (Next 30 Weekdays)</h2>
<?php if (isset($_GET['saved'])): ?>
    <p style="color: green;">Availability updated!</p>
<?php endif; ?>

<form method="post">
    <div class="grid-container">
        <?php foreach ($dates as $date): ?>
            <?php
                $checked = isset($availability[$date]) ? $availability[$date] == 1 : true;
                $formatted = date("l, F j", strtotime($date));
            ?>
            <label class="date-label">
                <input type="checkbox" name="available[]" value="<?= $date ?>" <?= $checked ? 'checked' : '' ?> style="margin-right: 10px;">
                <?= $formatted ?>
            </label>
        <?php endforeach; ?>
    </div>
    <div style="display: flex; justify-content: center; margin-top: 20px;">
    <input type="submit" value="Save Availability">
    </div>
</form>
<div style="text-align: center; margin-bottom: 20px;">
    <form method="post" action="clear-past-appointments.php" onsubmit="return confirm('Are you sure you want to delete all past appointments?');">
        <button type="submit" style="
            background-color: #e74c3c;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 6px;
            font-weight: bold;
            cursor: pointer;
        ">
            🗑️ Clear Past Appointments
        </button>
        <div style="text-align: center; margin-bottom: 20px;">
    <a href="testing.php" style="
        display: inline-block;
        padding: 10px 20px;
        background-color: #2ecc71;
        color: white;
        font-weight: bold;
        text-decoration: none;
        border-radius: 6px;
        box-shadow: 0 2px 6px rgba(0,0,0,0.2);
    ">
        ← Back to TPST Control Panel
    </a>
</div>
</form>
</div>
</body>
</html>
