<?php
session_start();
require 'db.php';

// Redirect if not logged in as admin
if (!isset($_SESSION['admin_id'])) {
    header("Location: admin-login.php");
    exit();
}
$admin_name = $_SESSION['admin_name'] ?? 'name';
?>


<!DOCTYPE html>
<html lang="en">
<head>
    <link rel="stylesheet" href="styles.css">
    <meta charset="UTF-8">
    <title>Admin Dashboard</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f5f5f5;
            padding: 40px;
        }
        .dashboard {
            max-width: 600px;
            margin: auto;
        }
        h2 {
            text-align: center;
            margin-bottom: 30px;
        }
        .card {
            background: rgba(255,255,255,0.80);
            padding: 20px;
            margin-bottom: 20px;
            border-radius: 8px;
            box-shadow: 0 0 8px rgba(0,0,0,0.1);
            text-align: center;
        }
        .card h3 {
            margin-bottom: 10px;
        }
        .card a {
            display: inline-block;
            padding: 10px 20px;
            background: #007bff;
            color: rgba(0,0,0,0.75);
            border-radius: 5px;
            text-decoration: none;
        }
        .card a:hover {
            background: #0056b3;
        }
    </style>
</head>
<body>
    <h2 style="text-align: center; color: white;">Welcome, <?= htmlspecialchars($admin_name); ?> – Admin Dashboard</h2>
    
    <div class="dashboard">
        <h2 style="text-align: center; color: white;"></h2>

        <div class="card">
            <h3>➕ Add Student</h3>
            <a href="create-student.php">Manual Entry</a>
        </div>

        <div class="card">
            <h3>📩 Bulk Upload Students</h3>
            <a href="upload-students.php">Upload CSV</a>
        </div>
        
        <div class="card">
            <h3>📄 Print Student Records</h3>    
            <a href="print-options.php" class="btn btn-primary">Generate Student Report</a>
        </div>
        
        <div class="card">
            <h3>📅 Schedule Drive Time</h3>
            <a href="admin-drive-booking.php">Assign Drive</a>
        </div>
        
        <div class="card">
            <h3>👨 Reassign Drive</h3>
        <a href="admin-drive-reassign.php">Reassign Instructor</a>
        </div>
        
        <div class="card">
            <h3>🔍 Lookup Student</h3>
            <a href="lookup-student.php">Search Records</a>
        </div>
         
        <div class="card">
             <h3>📄 Update Student Records</h3> 
             <a href="update-certificate.php">Assign Ctrl #</a>
        </div>
        
        <div class="card">
            <h3>🛞 Scheduling Approvals for Driving</h3> 
        <a href="section-drive-approval.php">Bulk Approve Students to Begin Driving</a>
        </div>

        <div class="card">
             <h3>🧑 Update Instructor</h3> 
             <a href="update-instructor.php">Add/Remove Instructor #</a>
        </div>
        
        <div class="card">
            <h3>🚗 Third Party Tester Dashboard</h3>
            <a href="https://tpst.tandddrivingacademy.com/testing.php">Go to TPST Control Panel</a>
        </div>

        <div class="card">
            <h3>🚪 Log Out</h3>
            <a href="admin-login.php">Logout</a>
        </div>
    </div>
</body>
</html>




