<?php
require 'db.php';
header('Content-Type: application/json');

if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['query'])) {
    $query = trim($_POST['query']);
    $like = "%" . $query . "%";

    $stmt = $conn->prepare("
        SELECT id, first_name, last_name, email 
        FROM Students 
        WHERE first_name LIKE ? OR last_name LIKE ? OR email LIKE ?
        ORDER BY last_name, first_name
        LIMIT 10
    ");
    $stmt->bind_param("sss", $like, $like, $like);
    $stmt->execute();
    $result = $stmt->get_result();

    $students = [];
    while ($row = $result->fetch_assoc()) {
        $students[] = $row;
    }

    echo json_encode($students);
    exit;
}

echo json_encode([]);
exit;
