<?php
require 'db.php';

$pw_token_confirm = trim($_GET['pw_token_confirm'] ?? '');
$confirmation_success = false;
$message = "";

if ($pw_token_confirm) {
    // Look up student by token
    $stmt = $conn->prepare("SELECT id, is_confirmed FROM Students WHERE pw_token_confirm = ?");
    $stmt->bind_param("s", $pw_token_confirm);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 1) {
        $student = $result->fetch_assoc();

        if ($student['is_confirmed'] == 0) {
            // Mark as confirmed and store timestamp
            $update = $conn->prepare("UPDATE Students SET is_confirmed = 1, confirmed_at = NOW() WHERE pw_token_confirm = ?");
            $update->bind_param("s", $pw_token_confirm);
            $update->execute();
            $update->close();

            $confirmation_success = true;
            $message = "Your account has been successfully confirmed! You may now log in.";
        } else {
            $message = "This account has already been confirmed.";
        }
    } else {
        $message = "Invalid or expired confirmation token.";
    }

    $stmt->close();
    
} else {
    $message = "No confirmation token provided.";
}

?>

<!DOCTYPE html>
<html>
<head>
    <link rel="stylesheet" href="styles.css">
    <title>Account Confirmation</title>
    <style>
        body {
            font-family: Arial, sans-serif;
        /*    background: #f4f4f4;  */
            text-align: center;
            padding-top: 100px;
        }
        .message-box {
            background: white;
            padding: 30px;
            border-radius: 1;
            display: inline-block;
            box-shadow: 0 0 10px rgba(0,0,0,0.2);
        }
        .message-box h2 {
            color: <?= $confirmation_success ? '#28a745' : '#dc3545' ?>;
        }
        .message-box a {
            display: inline-block;
            margin-top: 20px;
            color: #007bff;
            text-decoration: none;
        }
    </style>
</head>
<body>
    <div class="message-box">
        <h2><?= htmlspecialchars($message) ?></h2>
        <?php if ($confirmation_success): ?>
            <a href="student-login.php" class="login-link">Go to Login</a>
            <br><br>
            <a href="student-dashboard.php" class="dashboard-link">Go to Dashboard</a>
        <?php endif; ?>
    </div>
</body>
</html>