<?php
require_once __DIR__ . '/includes/PHPMailer/PHPMailer.php';
require_once __DIR__ . '/includes/PHPMailer/SMTP.php';
require_once __DIR__ . '/includes/PHPMailer/Exception.php';

require_once __DIR__ . '/vendor/setasign/fpdf/fpdf.php';  // <== This is what provides the FPDF class
require_once __DIR__ . '/vendor/autoload.php'; // Make sure this is after FPDF is loaded

use setasign\Fpdi\Fpdi;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

$mail = new PHPMailer();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name           = $_POST['student_name'] ?? '';
    $dob            = $_POST['dob'] ?? '';
    $email          = $_POST['student_email'] ?? '';
    $license        = $_POST['license_number'] ?? '';
    $address        = $_POST['address'] ?? '';
    $student_phone  = $_POST['student_phone'] ?? '';
    $parent_phone   = $_POST['parent_phone'] ?? '';
    // $student_cell   = $_POST['student_cell'] ?? '';

    // Start building the PDF
    $pdf = new \setasign\Fpdi\Fpdi('P', 'pt', 'Letter');  // P = Portrait, pt = points, Letter = 612x792 pts
    $pdf->AddPage();
    $pdf->setSourceFile('assets/TDStudentContract.pdf');
    $templateId = $pdf->importPage(1);
    $pdf->useTemplate($templateId, 0, 0, 612, 792);  // Explicit dimensions: full page, no scaling


    $pdf->SetFont('Arial');
    $pdf->SetTextColor(0, 0, 0);
    $pdf->SetFontSize(10);

    // Coordinates (converted from 300dpi)
    $pdf->SetXY(208, 132); $pdf->Write(0, $name);          // Student Full Name
    $pdf->SetXY(89, 154); $pdf->Write(0, $dob);            // Date of Birth
    $pdf->SetXY(101, 198); $pdf->Write(0, $email);         // Student Email
    $pdf->SetXY(230, 176); $pdf->Write(0, $license);        // Driver License #
    $pdf->SetXY(186, 260); $pdf->Write(0, $student_phone); // Student Cell Phone
    $pdf->SetXY(187, 236); $pdf->Write(0, $address);       // Street Address
    // $pdf->SetXY(190, 346); $pdf->Write(0, $student_cell);  // Mother's Phone
    $pdf->SetXY(186, 286); $pdf->Write(0, $parent_phone);  // Parent Phone


    $outputPath = __DIR__ . '/contracts/' . preg_replace('/\s+/', '_', $name) . '_contract.pdf';
    $pdf->Output('F', $outputPath);

    // Email to Admin
    $mail = new PHPMailer(true);
    try {
        $mail->isSMTP();
        $mail->Host       = 'mail.tandddrivingacademy.com';
        $mail->SMTPAuth   = true;
        $mail->Username   = 'no-reply@tandddrivingacademy.com';
        $mail->Password   = '!ResetPassword1!';
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
        $mail->Port       = 465;

        $mail->setFrom('no-reply@tandddrivingacademy.com', 'T&D Driving Academy');
        $mail->addAddress('no-reply@tandddrivingacademy.com');
        $mail->addAttachment($outputPath);

        $mail->isHTML(true);
        $mail->Subject = "New Teen Registration - $name";
        $mail->Body    = "A new teen student has registered. See attached contract.";

        $mail->send();
        header("Location: confirmation.php");
            exit;
    } catch (Exception $e) {
        echo "<p>Mailer Error: {$mail->ErrorInfo}</p>";
    }
} else {
    echo "<p>Invalid submission.</p>";
}

