<?php
require 'db.php';

header('Content-Type: application/json');

if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['student_id'])) {
    $student_id = intval($_POST['student_id']);

    $stmt = $conn->prepare("
        SELECT permit_number, permit_received_at, de964_number, ade1317_number, duplicate_de964, duplicate_ade1317
        FROM Students
        WHERE id = ?
    ");
    $stmt->bind_param("i", $student_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $student = $result->fetch_assoc();
    $stmt->close();

    // Driving minutes
    $minutes_stmt = $conn->prepare("
        SELECT 
            COALESCE(SUM(btw_minutes), 0) AS total_btw,
            COALESCE(SUM(ob_minutes), 0) AS total_ob
        FROM DriveSchedule
        WHERE student_id = ?
    ");
    $minutes_stmt->bind_param("i", $student_id);
    $minutes_stmt->execute();
    $minutes = $minutes_stmt->get_result()->fetch_assoc();
    $minutes_stmt->close();

    // Add minutes to output
    $student['total_btw'] = $minutes['total_btw'];
    $student['total_ob'] = $minutes['total_ob'];

    // Days remaining before expiration
    if (!empty($student['permit_received_at'])) {
        $permit_date = new DateTime($student['permit_received_at']);
        $expiry_date = (clone $permit_date)->modify('+6 months');
        $today = new DateTime();
        $interval = $today->diff($expiry_date);
        $student['days_remaining'] = $interval->invert ? 0 : $interval->days;
    } else {
        $student['days_remaining'] = 'N/A';
    }

    echo json_encode($student ?: []);
    exit;
}

echo json_encode(['error' => 'Invalid request']);
