<?php
// Debug mode
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Load DB connection (adjust path if needed)
require_once '../tpst/db.php';

// Step 1: Extract the subdomain
$host = $_SERVER['HTTP_HOST']; // e.g., testuser.bookings.tandddrivingacademy.com
$host_parts = explode('.', $host);

// Safety: only extract subdomain if domain is structured correctly
$subdomain = (count($host_parts) >= 3) ? $host_parts[0] : null;

if (!$subdomain) {
    echo "<h2>No valid subdomain detected.</h2>";
    exit;
}

echo "<h2>Subdomain Detected: <strong>$subdomain</strong></h2>";

// Step 2: Lookup subscriber
$stmt = $conn->prepare("SELECT first_name, last_name, tier_choice FROM Subscribers WHERE username = ?");
$stmt->bind_param("s", $subdomain);
$stmt->execute();
$result = $stmt->get_result();

if ($result && $result->num_rows > 0) {
    $subscriber = $result->fetch_assoc();
    echo "<p>Welcome <strong>{$subscriber['first_name']} {$subscriber['last_name']}</strong>!</p>";
    echo "<p>Your tier is: <strong>{$subscriber['tier_choice']}</strong></p>";
} else {
    echo "<p style='color: red;'>No subscriber found for <strong>$subdomain</strong>.</p>";
}
?>
