<?php
require 'db.php';
session_start();

if (!isset($_SESSION['admin_id'])) {
    header("Location: admin-login.php");
    exit();
}

// Fetch instructors
$result = $conn->query("SELECT id, first_name, last_name, email, license_number, license_expiration FROM Instructors ORDER BY last_name, first_name");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Instructor List</title>
    <link rel="stylesheet" href="styles.css">
    <style>
        .container {
            max-width: 900px;
            margin: 100px auto;
            padding: 25px;
            background: rgba(255, 255, 255, 0.95);
            border-radius: 10px;
        }
        table {
            width: 100%;
            margin-top: 20px;
            border-collapse: collapse;
        }
        th, td {
            padding: 10px;
            border: 1px solid #ccc;
            text-align: left;
        }
        th {
            background-color: #f4f4f4;
        }
        h2 {
            margin-bottom: 20px;
            text-align: center;
        }
        .btn {
            margin-top: 20px;
            padding: 10px 20px;
            background-color: #007bff;
            border: none;
            color: white;
            border-radius: 5px;
            cursor: pointer;
            display: block;
            margin-left: auto;
            margin-right: auto;
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Current Instructor Roster</h2>
        <table>
            <thead>
                <tr>
                    <th>Name</th>
                    <th>Email</th>
                    <th>License #</th>
                    <th>License Expiration</th>
                </tr>
            </thead>
            <tbody>
                <?php while ($row = $result->fetch_assoc()): ?>
                    <tr>
                        <td><?= htmlspecialchars($row['last_name'] . ', ' . $row['first_name']) ?></td>
                        <td><?= htmlspecialchars($row['email']) ?></td>
                        <td><?= isset($row['license_number']) ? htmlspecialchars($row['license_number']) : '—' ?></td>
                        <td><?= isset($row['license_expiration']) ? htmlspecialchars($row['license_expiration']) : '—' ?></td>
                    </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
        <a href="admin-dashboard.php" class="btn">← Back to Dashboard</a>
    </div>
</body>
</html>
