document.addEventListener("DOMContentLoaded", () => {
    const input = document.getElementById("sectionInput");
    const suggestionsBox = document.createElement("div");
    suggestionsBox.id = "sectionSuggestions";
    Object.assign(suggestionsBox.style, {
        position: "absolute",
        border: "1px solid #ccc",
        background: "#fff",
        zIndex: "10",
        display: "none"
    });
    document.body.appendChild(suggestionsBox);

    const tableContainer = document.getElementById("studentTableContainer");
    const tableBody = document.querySelector("#studentTable tbody");
    const selectAll = document.getElementById("selectAll");
    const saveButton = document.getElementById("saveApprovals");

    // Utility to render all students in table
    function renderStudentTable(data) {
        tableBody.innerHTML = "";

        data.forEach(student => {
            const row = document.createElement("tr");

            const checkboxCell = document.createElement("td");
            const checkbox = document.createElement("input");
            checkbox.type = "checkbox";
            checkbox.classList.add("student-check");
            checkbox.dataset.id = student.id;
            checkbox.checked = student.classroom_completed == 1;
            checkboxCell.appendChild(checkbox);

            const nameCell = document.createElement("td");
            nameCell.textContent = `${student.last_name}, ${student.first_name}`;

            const permitCell = document.createElement("td");
            permitCell.textContent = student.permit_number || "—";

            const statusCell = document.createElement("td");
            statusCell.textContent = student.classroom_completed == 1 ? "Approved" : "Not Approved";

            row.appendChild(checkboxCell);
            row.appendChild(nameCell);
            row.appendChild(permitCell);
            row.appendChild(statusCell);

            tableBody.appendChild(row);
        });

        tableContainer.style.display = "block";
    }

    // Fetch and render students by section
    function loadSection(section) {
        fetch("fetch-section-students.php", {
            method: "POST",
            headers: { "Content-Type": "application/x-www-form-urlencoded" },
            body: "section_code=" + encodeURIComponent(section)
        })
        .then(res => res.json())
        .then(data => {
            if (data.length === 0) {
                alert("No students found.");
                tableContainer.style.display = "none";
                return;
            }
            renderStudentTable(data);
        });
    }

    // Autocomplete logic
    input.addEventListener("input", () => {
        const query = input.value.trim();
        if (query.length < 2) {
            suggestionsBox.style.display = "none";
            return;
        }

        fetch("section-code-suggestions.php", {
            method: "POST",
            headers: { "Content-Type": "application/x-www-form-urlencoded" },
            body: "query=" + encodeURIComponent(query)
        })
        .then(res => res.json())
        .then(data => {
            suggestionsBox.innerHTML = "";
            if (!Array.isArray(data) || data.length === 0) {
                suggestionsBox.style.display = "none";
                return;
            }

            data.forEach(code => {
                const item = document.createElement("div");
                item.textContent = code;
                item.style.padding = "8px";
                item.style.cursor = "pointer";

                item.addEventListener("click", () => {
                    input.value = code;
                    suggestionsBox.style.display = "none";
                });

                suggestionsBox.appendChild(item);
            });

            const rect = input.getBoundingClientRect();
            suggestionsBox.style.top = rect.bottom + window.scrollY + "px";
            suggestionsBox.style.left = rect.left + "px";
            suggestionsBox.style.width = rect.width + "px";
            suggestionsBox.style.display = "block";
        });
    });

    document.addEventListener("click", (e) => {
        if (!suggestionsBox.contains(e.target) && e.target !== input) {
            suggestionsBox.style.display = "none";
        }
    });

    // Load section on button click
    document.getElementById("loadSectionBtn").addEventListener("click", () => {
        const section = input.value.trim();
        if (section) {
            loadSection(section);
        }
    });

    // Select All logic
    selectAll.addEventListener("change", () => {
        document.querySelectorAll(".student-check").forEach(cb => {
            cb.checked = selectAll.checked;
        });
    });

    // Save approvals
    saveButton.addEventListener("click", () => {
        const updates = [];
        document.querySelectorAll(".student-check").forEach(cb => {
            updates.push({
                id: cb.dataset.id,
                approved: cb.checked ? 1 : 0
            });
        });

        fetch("save-drive-approvals.php", {
            method: "POST",
            headers: { "Content-Type": "application/json" },
            body: JSON.stringify({ updates })
        })
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                alert("Drive approvals updated!");
                const section = input.value.trim();
                if (section) {
                    loadSection(section); // 💥 reload data from the section again
                }
            } else {
                alert("Error saving approvals.");
            }
        });
    });
});




      

