document.addEventListener("DOMContentLoaded", function () {
    const input = document.getElementById("studentSearch");
    const suggestionsBox = document.getElementById("suggestions");
    const hiddenInput = document.getElementById("studentId");

    if (!input || !suggestionsBox || !hiddenInput) return;

    input.addEventListener("input", function () {
        const query = input.value.trim();
        if (query.length < 2) {
            suggestionsBox.innerHTML = "";
            return;
        }

        fetch("lookup-student-search.php", {
            method: "POST",
            headers: {
                "Content-Type": "application/x-www-form-urlencoded",
                "X-Requested-With": "XMLHttpRequest"
            },
            body: "search=" + encodeURIComponent(query)
        })
        .then(response => response.json())
        .then(data => {
            suggestionsBox.innerHTML = "";
            if (data.length === 0) {
                const noResult = document.createElement("div");
                noResult.classList.add("suggestion-item");
                noResult.textContent = "No matches found.";
                suggestionsBox.appendChild(noResult);
                return;
            }

            data.forEach(student => {
                const item = document.createElement("div");
                item.classList.add("suggestion-item");
                item.textContent = `${student.first_name} ${student.last_name}`;
                item.dataset.studentId = student.id;
                item.addEventListener("click", () => {
                    input.value = `${student.first_name} ${student.last_name}`;
                    hiddenInput.value = student.id;
                    suggestionsBox.innerHTML = "";
                });
                suggestionsBox.appendChild(item);
            });
        })
        .catch(err => {
            console.error("Lookup Suggestion Error:", err);
        });
    });
});





