document.addEventListener("DOMContentLoaded", () => {
    const searchInput = document.getElementById("instructorSearch");
    const suggestionsBox = document.getElementById("instructorSuggestions");

    searchInput.addEventListener("input", () => {
        const query = searchInput.value.trim();
        if (query.length < 2) {
            suggestionsBox.style.display = "none";
            return;
        }

        fetch("lookup-instructor.php", {
            method: "POST",
            headers: { "Content-Type": "application/x-www-form-urlencoded" },
            body: "query=" + encodeURIComponent(query)
        })
        .then(res => res.json())
        .then(data => {
            suggestionsBox.innerHTML = "";
            if (!Array.isArray(data) || data.length === 0) {
                suggestionsBox.style.display = "none";
                return;
            }

            data.forEach(inst => {
                const div = document.createElement("div");
                div.textContent = `${inst.last_name}, ${inst.first_name} – ${inst.email}`;
                div.style.padding = "8px";
                div.style.cursor = "pointer";
                div.style.borderBottom = "1px solid #ccc";
                div.addEventListener("click", () => {
                    document.querySelector('input[name="id"]').value = inst.id;
                    document.querySelector('input[name="first_name"]').value = inst.first_name;
                    document.querySelector('input[name="last_name"]').value = inst.last_name;
                    document.querySelector('input[name="email"]').value = inst.email;
                    document.querySelector('input[name="license_number"]').value = inst.license_number || '';
                    document.querySelector('input[name="license_expiration"]').value = inst.license_expiration || '';

                    suggestionsBox.style.display = "none";
                    searchInput.value = `${inst.last_name}, ${inst.first_name}`;
                });
                suggestionsBox.appendChild(div);
            });

            const rect = searchInput.getBoundingClientRect();
            suggestionsBox.style.position = "absolute";
            suggestionsBox.style.background = "#fff";
            suggestionsBox.style.border = "1px solid #ccc";
            suggestionsBox.style.top = rect.bottom + window.scrollY + "px";
            suggestionsBox.style.left = rect.left + "px";
            suggestionsBox.style.width = rect.width + "px";
            suggestionsBox.style.display = "block";
        });
    });

    document.addEventListener("click", (e) => {
        if (!suggestionsBox.contains(e.target) && e.target !== searchInput) {
            suggestionsBox.style.display = "none";
        }
    });
});
