<?php
require 'db.php';
header('Content-Type: application/json');

if ($_SERVER["REQUEST_METHOD"] === "GET" && isset($_GET['term'])) {
    $term = trim($_GET['term']);
    $like = "%" . $term . "%";

    $stmt = $conn->prepare("
        SELECT id, CONCAT(last_name, ', ', first_name) AS name
        FROM Students
        WHERE first_name LIKE ? OR last_name LIKE ? OR email LIKE ?
        ORDER BY last_name ASC, first_name ASC
        LIMIT 10
    ");
    $stmt->bind_param("sss", $like, $like, $like);
    $stmt->execute();
    $result = $stmt->get_result();

    $results = [];
    while ($row = $result->fetch_assoc()) {
        $results[] = $row;
    }

    echo json_encode($results);
    exit;
}

echo json_encode([]);
exit;

