<?php
require 'db.php';

header('Content-Type: application/json');

if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['query'])) {
    $search = '%' . trim($_POST['query']) . '%';

    $stmt = $conn->prepare("
        SELECT id, first_name, last_name 
        FROM Instructors 
        WHERE first_name LIKE ? OR last_name LIKE ? OR CONCAT(first_name, ' ', last_name) LIKE ?
        ORDER BY last_name, first_name
        LIMIT 10
    ");
    $stmt->bind_param("sss", $search, $search, $search);
    $stmt->execute();
    $result = $stmt->get_result();

    $instructors = [];
    while ($row = $result->fetch_assoc()) {
        $instructors[] = [
            'id' => $row['id'],
            'first_name' => $row['first_name'],
            'last_name' => $row['last_name']
        ];
    }

    echo json_encode($instructors);
    $stmt->close();
} else {
    echo json_encode([]);
}
?>
