<?php
session_start();
require 'db.php';

$error = "";
$results = [];

if ($_SERVER["REQUEST_METHOD"] === "POST" && !empty($_POST['search'])) {
    $query = trim($_POST['search']);
    $like = "%$query%";

    $stmt = $conn->prepare("
        SELECT id, first_name, last_name, email, section_code, de964_number, ade1317_number, 
               duplicate_de964, duplicate_ade1317, permit_number, permit_received_at
        FROM Students
        WHERE 
            first_name LIKE ? OR 
            last_name LIKE ? OR 
            email LIKE ? OR 
            section_code LIKE ?
    ");
    $stmt->bind_param("ssss", $like, $like, $like, $like);
    $stmt->execute();
    $result = $stmt->get_result();

    while ($row = $result->fetch_assoc()) {
        $student_id = $row['id'];

        // Get total drive minutes
        $minutes_stmt = $conn->prepare("
            SELECT COALESCE(SUM(btw_minutes), 0) AS total_btw, COALESCE(SUM(ob_minutes), 0) AS total_ob
            FROM DriveSchedule WHERE student_id = ?
        ");
        $minutes_stmt->bind_param("i", $student_id);
        $minutes_stmt->execute();
        $minutes_data = $minutes_stmt->get_result()->fetch_assoc();
        $minutes_stmt->close();

        $row['total_btw'] = $minutes_data['total_btw'];
        $row['total_ob'] = $minutes_data['total_ob'];

        // Days remaining logic
        if (!empty($row['permit_received_at'])) {
            $permit_date = new DateTime($row['permit_received_at']);
            $expiry = (clone $permit_date)->modify('+6 months');
            $today = new DateTime();
            $diff = $today->diff($expiry);
            $row['days_remaining'] = $diff->invert ? 0 : $diff->days;
        } else {
            $row['days_remaining'] = 'N/A';
        }

        $results[] = $row;
    }

    $stmt->close();
} elseif ($_SERVER["REQUEST_METHOD"] === "POST") {
    $error = "Please enter a name or email to search.";
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Lookup Student</title>
    <link rel="stylesheet" href="styles.css">
    <style>
        .container { max-width: 700px; margin: 120px auto; padding: 25px; background: #fff; border-radius: 10px; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
        h2 { text-align: center; }
        .student { background: #f8f8f8; padding: 15px; margin-top: 20px; border-radius: 8px; }
        label, input[type=text], input[type=submit] { display: block; width: 100%; margin-top: 10px; }
        input[type=submit] { background: #007bff; color: #fff; border: none; padding: 10px; border-radius: 5px; cursor: pointer; }
        .error { color: red; text-align: center; }
    </style>
</head>
<body>
<div class="container">
    <h2>Lookup Student</h2>

    <?php if ($error): ?>
        <p class="error"><?= $error ?></p>
    <?php endif; ?>

    <form method="post">
        <label for="search">Enter Name, Email, or Section Code:</label>
        <input type="text" id="search" name="search" required>
        <input type="submit" value="Search">
    </form>

    <?php foreach ($results as $student): ?>
        <div class="student">
            <p><strong>Name:</strong> <?= htmlspecialchars($student['first_name'] . ' ' . $student['last_name']) ?></p>
            <p><strong>Email:</strong> <?= htmlspecialchars($student['email']) ?></p>
            <p><strong>Section Code:</strong> <?= htmlspecialchars($student['section_code'] ?? 'N/A') ?></p>
            <p><strong>Permit Number:</strong> <?= htmlspecialchars($student['permit_number'] ?? 'N/A') ?></p>
            <p><strong>Permit Issued:</strong> <?= htmlspecialchars($student['permit_received_at'] ?? 'N/A') ?></p>
            <p><strong>Days Left (Countdown):</strong> <?= is_numeric($student['days_remaining']) ? $student['days_remaining'] . " days" : 'N/A' ?></p>
            <p><strong>Total Behind-the-Wheel Minutes:</strong> <?= $student['total_btw'] ?> minutes</p>
            <p><strong>Total Observation Minutes:</strong> <?= $student['total_ob'] ?> minutes</p>
        </div>
    <?php endforeach; ?>
</div>
</body>
</html>
