<?php
session_start();
require 'db.php';

$results = [];
$error = '';

if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['search'])) {
    $query = trim($_POST['search']);
    $like = "%$query%";

    $stmt = $conn->prepare("
        SELECT * FROM Students 
        WHERE 
            first_name LIKE ? OR 
            last_name LIKE ? OR 
            CONCAT(first_name, ' ', last_name) LIKE ?
    ");
    $stmt->bind_param("sss", $like, $like, $like);
    $stmt->execute();
    $students = $stmt->get_result();

    while ($student = $students->fetch_assoc()) {
        $student_id = $student['id'];

        // Calculate minutes
        $minutesStmt = $conn->prepare("
            SELECT 
                COALESCE(SUM(btw_minutes), 0) AS total_btw,
                COALESCE(SUM(ob_minutes), 0) AS total_ob
            FROM DriveSchedule
            WHERE student_id = ?
        ");
        $minutesStmt->bind_param("i", $student_id);
        $minutesStmt->execute();
        $mins = $minutesStmt->get_result()->fetch_assoc();
        $minutesStmt->close();

        $student['total_btw'] = $mins['total_btw'];
        $student['total_ob'] = $mins['total_ob'];

        // Countdown logic
        if (!empty($student['permit_received_at'])) {
            $permit_date = new DateTime($student['permit_received_at']);
            $expiry_date = (clone $permit_date)->modify('+6 months');
            $today = new DateTime();
            $interval = $today->diff($expiry_date);
            $student['days_remaining'] = $interval->invert ? 0 : $interval->days;
        } else {
            $student['days_remaining'] = 'N/A';
        }

        $results[] = $student;
    }

    $stmt->close();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Lookup Student</title>
    <link rel="stylesheet" href="styles.css">
    <style>
        .container {
            max-width: 600px;
            margin: 150px auto;
            padding: 25px;
            border-radius: 10px;
            background: rgba(255,255,255,0.90);
            box-shadow: 0 0 15px rgba(0,0,0,0.1);
        }
        input[type="text"], input[type="submit"] {
            width: 100%;
            padding: 12px;
            margin-bottom: 10px;
        }
        .student {
            background: #f9f9f9;
            padding: 15px;
            margin-top: 20px;
            border-radius: 8px;
        }
        h2 { text-align: center; }
    </style>
</head>
<body>
<div class="container">
    <h2>Lookup Student</h2>

    <form method="post">
        <input type="text" name="search" placeholder="Enter full or partial name..." required>
        <input type="submit" value="Search">
    </form>

    <?php if ($_SERVER["REQUEST_METHOD"] === "POST" && empty($results)): ?>
        <p style="color: red;">No matching students found.</p>
    <?php endif; ?>

    <?php foreach ($results as $student): ?>
        <div class="student">
            <p><strong>Name:</strong> <?= htmlspecialchars($student['first_name'] . ' ' . $student['last_name']) ?></p>
            <p><strong>Email:</strong> <?= htmlspecialchars($student['email']) ?></p>
            <p><strong>Section Code:</strong> <?= htmlspecialchars($student['section_code'] ?: 'N/A') ?></p>
            <p><strong>Classroom Completed:</strong> <?= $student['classroom_completed'] ? 'Yes' : 'No' ?></p>
            <p><strong>Permit Number:</strong> <?= htmlspecialchars($student['permit_number'] ?: 'Not provided') ?></p>
            <p><strong>Days Remaining:</strong> <?= is_numeric($student['days_remaining']) ? $student['days_remaining'] . ' days' : 'N/A' ?></p>
            <p><strong>DE-964:</strong> <?= $student['de964_number'] ?: 'N/A' ?></p>
            <p><strong>ADE-1317:</strong> <?= $student['ade1317_number'] ?: 'N/A' ?></p>
            <p><strong>BTW Minutes:</strong> <?= $student['total_btw'] ?> mins</p>
            <p><strong>Observation Minutes:</strong> <?= $student['total_ob'] ?> mins</p>
        </div>
    <?php endforeach; ?>
    <form action="admin-dashboard.php" method="get" style="text-align: center; margin-top: 30px;">
    <input type="submit" value="Return to Dashboard" style="padding: 10px 20px; background-color: #007bff; color: white; border: none; border-radius: 5px; cursor: pointer;">
</form>

</div>

</body>
</html>





