<?php
require 'db.php';
header('Content-Type: application/json');

$data = json_decode(file_get_contents("php://input"), true);

if (!isset($data['updates']) || !is_array($data['updates'])) {
    echo json_encode(['success' => false, 'message' => 'Invalid data']);
    exit;
}

$stmt = $conn->prepare("UPDATE Students SET classroom_completed = ? WHERE id = ?");

foreach ($data['updates'] as $update) {
    $approved = isset($update['approved']) && $update['approved'] == 1 ? 1 : 0;
    $student_id = intval($update['id']);

    $stmt->bind_param("ii", $approved, $student_id);
    $stmt->execute();
}

$stmt->close();

echo json_encode(['success' => true]);
