<?php
require 'db.php';
header('Content-Type: application/json');

if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['query'])) {
    $query = '%' . trim($_POST['query']) . '%';

    $stmt = $conn->prepare("
        SELECT DISTINCT section_code 
        FROM Students 
        WHERE section_code LIKE ? 
        ORDER BY section_code ASC
        LIMIT 10
    ");
    $stmt->bind_param("s", $query);
    $stmt->execute();
    $result = $stmt->get_result();

    $codes = [];
    while ($row = $result->fetch_assoc()) {
        $codes[] = $row['section_code'];
    }

    echo json_encode($codes);
} else {
    echo json_encode([]);
}
