<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Section Drive Approval</title>
    <link rel="stylesheet" href="styles.css">
    <style>
        .container {
            max-width: 800px;
            margin: 100px auto;
            padding: 25px;
            background: rgba(255,255,255,0.95);
            border-radius: 10px;
        }
        table {
            width: 100%;
            margin-top: 20px;
            border-collapse: collapse;
        }
        th, td {
            border: 1px solid #ccc;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f4f4f4;
        }
        .btn {
            margin-top: 15px;
            padding: 10px 20px;
            background-color: #007bff;
            border: none;
            color: white;
            border-radius: 5px;
            cursor: pointer;
        }
    </style>
</head>
<body>
<div class="container">
    <h2>Drive Time Approval by Section</h2>

    <label for="sectionInput">Enter Section Code:</label>
    <input type="text" id="sectionInput" placeholder="e.g., T.00.2025" autocomplete="off" style="width: 100%; padding: 10px; margin-top: 5px;">
    <div id="sectionSuggestions" style="border: 1px solid #ccc; display: none; background: #fff; position: absolute; z-index: 10;"></div>
    <button id="loadSectionBtn" class="btn" style="margin-top: 10px;">Load Students</button>

    <div id="studentTableContainer" style="display: none;">
        <table id="studentTable">
            <thead>
                <tr>
                    <th><input type="checkbox" id="selectAll"></th>
                    <th>Name</th>
                    <th>Permit</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody></tbody>
        </table>
        <button class="btn" id="saveApprovals">Save Approvals</button>
    </div>
    <form action="admin-dashboard.php" method="get" style="margin-top: 20px; text-align: center;">
    <button type="submit" class="btn" style="background-color: #6c757d;">Back to Dashboard</button>
</form>

</div>

<script src="js/section-drive-approval.js"></script>
</body>
</html>
