<?php
session_start();

// Database connection
$conn = new mysqli("localhost", "tandddri_admin", "!S0ngw3av3r1!", "tandddri_Students");
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$error = "";

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $email = trim($_POST['email']);
    $password = trim($_POST['password']);

    // 🔁 Add is_confirmed to the query
    $stmt = $conn->prepare("SELECT id, password, last_name, first_name, is_confirmed FROM Students WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 1) {
        $row = $result->fetch_assoc();

        // ✅ Check password first
        if (password_verify($password, $row['password'])) {

            // ✅ Check if account is confirmed
            if ($row['is_confirmed'] == 0) {
                $error = "Please confirm your email before logging in.";
            } else {
                // Success: confirmed + valid password
                $_SESSION['student_id'] = $row['id'];
                $_SESSION['student_name'] = $row['first_name'] . ' ' . $row['last_name'];
                header("Location: student-dashboard.php");
                exit();
            }

        } else {
            $error = "Invalid password.";
        }
    } else {
        $error = "Email not found.";
    }

    $stmt->close();
    $conn->close();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Student Login</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: url('hotrod-1.jpg') no-repeat center center fixed;
            background-size: cover;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
            transform: translateY(150px);
        }
        .login-container {
            background-color: rgba(255, 255, 255, 0.9);
            padding: 20px 30px;
            border-radius: 10px;
            box-shadow: 0px 0px 10px rgba(0,0,0,0.3);
            text-align: center;
        }
        .login-container h2 {
            margin-bottom: 20px;
        }
        .login-container input[type=email],
        .login-container input[type=password] {
            width: 100%;
            padding: 10px;
            margin-bottom: 15px;
            border: 1px solid #ccc;
            border-radius: 5px;
        }
        .login-container input[type=submit] {
            width: 100%;
            padding: 10px;
            background-color: #ff6c2c;
            color: #fff;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }
        .error {
            color: red;
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <h2>Student Login</h2>
        <?php if (!empty($error)): ?>
    <p style="color: red; text-align: center;"><?= htmlspecialchars($error) ?></p>
        <?php endif; ?>
        <form method="post" action="">
            <input type="email" name="email" placeholder="Email" required>
            <input type="password" name="password" placeholder="Password" required>
            <input type="submit" value="Login">
        </form>
        <div style="margin-top: 10px;">
        <a href="password-recovery.php?role=student">Forgot your password?</a>
        </div>
    </div>
    
</body>
</html>
