<?php
session_start();
require 'db.php';

$success = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = $_POST['email'] ?? '';
    $token = bin2hex(random_bytes(32));
    $expires = date('Y-m-d H:i:s', strtotime('+1 hour'));

    // Check if the email exists in AdminTPST
    $stmt = $conn->prepare("SELECT id FROM AdminTPST WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows === 1) {
        // Insert token into PasswordResets table
        $stmt->close();

        $stmt = $conn->prepare("INSERT INTO PasswordResets (email, user_type, token, expires_at) VALUES (?, 'admin', ?, ?)");
        $stmt->bind_param("sss", $email, $token, $expires);
        $stmt->execute();

        // Send reset email
        $reset_link = "admin-reset-password.php?token=$token";

        // Send using mail() or PHPMailer (if already configured)
        mail($email, "Reset Your Admin Password", "Click here to reset your password:\n\n$reset_link");

        $success = "✅ A reset link has been sent to your email.";
    } else {
        $error = "No admin account found with that email.";
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Admin Password Reset</title>
    <style>
        body { background: #2c3e50; color: white; font-family: Arial; display: flex; justify-content: center; align-items: center; height: 100vh; }
        .box { background: rgba(0,0,0,0.7); padding: 30px; border-radius: 10px; width: 400px; text-align: center; }
        input[type="email"] { width: 100%; padding: 10px; border-radius: 6px; border: none; margin-top: 10px; }
        button { padding: 12px; width: 100%; background: #1abc9c; color: white; font-weight: bold; border: none; border-radius: 6px; margin-top: 20px; }
        .success { color: #2ecc71; margin-top: 15px; }
        .error { color: #e74c3c; margin-top: 15px; }
    </style>
</head>
<body>
    <div class="box">
        <h2>Reset Admin Password</h2>
        <form method="POST">
            <label for="email">Enter your admin email:</label><br>
            <input type="email" name="email" id="email" required>
            <button type="submit">Send Reset Link</button>
        </form>
        <?php if ($success): ?><p class="success"><?= $success ?></p><?php endif; ?>
        <?php if ($error): ?><p class="error"><?= $error ?></p><?php endif; ?>
    </div>
</body>
</html>
