<?php
session_start();
require 'tpst/db.php';

// Get submitted login credentials
$email = isset($_POST['email']) ? trim($_POST['email']) : '';
$password = isset($_POST['password']) ? $_POST['password'] : '';

// Validate input
if (empty($email) || empty($password)) {
    die("Missing email or password.");
}

// Look up subscriber
$stmt = $conn->prepare("SELECT sub_id, dashboard_type, password_hash FROM Subscribers WHERE email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();

if ($result && $result->num_rows === 1) {
    $row = $result->fetch_assoc();

    // Check password
    if (password_verify($password, $row['password_hash'])) {
        // Set session data
        $_SESSION['sub_id'] = $row['sub_id'];
        $_SESSION['dashboard_type'] = $row['dashboard_type'];

        // Route based on tier
        if ($row['dashboard_type'] === 'pro') {
            header("Location: dashboard-pro.php");
        } else {
            header("Location: dashboard-basic.php");
        }
        exit();
    } else {
        echo "Invalid password.";
    }
} else {
    echo "No account found with that email.";
}
?>
