<?php

session_start();
require_once __DIR__ . '/../tpst/db.php';

// ✅ Admin-only access
if (empty($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: /tpst/login-tpst.php");
    exit;
}

// Continue normal execution for allowed user

$stmt = $conn->prepare("
    SELECT id, test_appointment_id, filename 
    FROM TestDocuments
");

$stmt->execute();
$result = $stmt->get_result();

$deleted = 0;
$failed = [];

while ($row = $result->fetch_assoc()) {
    $file_path = __DIR__ . "/uploads/applicant/{$row['test_appointment_id']}/{$row['filename']}";

    if (file_exists($file_path)) {
        if (unlink($file_path)) {
            // File deleted, remove from DB
            $del = $conn->prepare("DELETE FROM TestDocuments WHERE id = ?");
            $del->bind_param("i", $row['id']);
            $del->execute();
            $deleted++;
        } else {
            $failed[] = $file_path;
        }
    } else {
        // Remove DB entry if file is already gone
        $del = $conn->prepare("DELETE FROM TestDocuments WHERE id = ?");
        $del->bind_param("i", $row['id']);
        $del->execute();
    }
}

echo "<h3>Mass Deletion Complete</h3>";
echo "<p>✅ Deleted $deleted document(s).</p>";

if (!empty($failed)) {
    echo "<p style='color: red;'>⚠ Failed to delete some files:</p><ul>";
    foreach ($failed as $f) {
        echo "<li>$f</li>";
    }
    echo "</ul>";
}
?>
