<?php
session_start();

require_once 'db.php';

// ✅ Grant admin full access
if (!empty($_SESSION['admin_logged_in'])) {
    $features = [
        'can_upload_documents' => true,
        'can_access_log_testing' => true
    ];
} else {
    // ✅ Subscriber check
    if (empty($_SESSION['subscriber_id']) || empty($_SESSION['tier_choice'])) {
        header("Location: login-tpst.php");
        exit;
    }

    $tier = $_SESSION['tier_choice'];
    $features = $tier_permissions[$tier] ?? $tier_permissions['basic'];

    if (empty($features['can_upload_documents'])) {
        header("Location: /tpst/no-doc-access.php");
        exit;
    }
}

// Continue normal execution for allowed user

$zip_created = false;
$zip_file = '';
$generated_date = '';

// Generate ZIP if date is posted
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['generate_date'])) {
    $date = $_POST['generate_date'];
    $generated_date = $date;

    $stmt = $conn->prepare("
        SELECT ta.full_name, ta.id AS test_appointment_id, td.filename
        FROM TestAppointments ta
        JOIN TestDocuments td ON ta.id = td.test_appointment_id
        WHERE ta.test_date = ?
    ");
    $stmt->bind_param("s", $date);
    $stmt->execute();
    $result = $stmt->get_result();

    $documents = [];
    while ($row = $result->fetch_assoc()) {
        $documents[] = $row;
    }
    $stmt->close();

    if (!empty($documents)) {
        $zip_file = "/uploads/daily_uploads_" . $date . ".zip";
        $zip = new ZipArchive();

        if ($zip->open($zip_file, ZipArchive::CREATE | ZipArchive::OVERWRITE)) {
            foreach ($documents as $doc) {
                $file_path = "/uploads/applicant/{$doc['test_appointment_id']}/{$doc['filename']}";
                if (file_exists($file_path)) {
                    $zip->addFile($file_path, $doc['full_name'] . '/' . basename($file_path));
                }
            }
            $zip->close();
            $zip_created = true;
        }
    }
}

// Get all distinct test dates with uploads
$date_stmt = $conn->query("
    SELECT DISTINCT ta.test_date
    FROM TestAppointments ta
    JOIN TestDocuments td ON ta.id = td.test_appointment_id
    ORDER BY ta.test_date DESC
");

$available_dates = [];
while ($row = $date_stmt->fetch_assoc()) {
    $available_dates[] = $row['test_date'];
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Download Daily Uploads</title>
    <link rel="stylesheet" href="../styles.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            background: linear-gradient(to right, #2c3e50, #34495e);
            color: white;
            text-align: center;
            padding: 60px 20px;
        }
        .form-box {
            background: rgba(255,255,255,0.1);
            padding: 30px;
            border-radius: 10px;
            display: inline-block;
        }
        input[type="date"] {
            padding: 10px;
            font-size: 16px;
        }
        button {
            padding: 12px 20px;
            margin-top: 15px;
            background-color: #27ae60;
            border: none;
            color: white;
            font-weight: bold;
            border-radius: 6px;
            cursor: pointer;
        }
        button:hover {
            background-color: #1e8449;
        }
        .download-link {
            margin-top: 30px;
        }
        ul.zip-list {
            margin-top: 40px;
            list-style-type: none;
            padding: 0;
        }
        ul.zip-list li {
            margin: 10px 0;
            font-size: 18px;
        }
        ul.zip-list a {
            color: #1abc9c;
            text-decoration: none;
            font-weight: bold;
        }
        ul.zip-list a:hover {
            text-decoration: underline;
        }
        h1 {
            color: white;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.8);
            font-size: 32px;
            margin-bottom: 30px;
        }
    </style>
    </head>
    <body>

    <h1>Generate Daily Applicant ZIPs</h1>

    <p>Select a date to generate and download a ZIP archive of all applicant documents uploaded for that day.</p>

    <?php if (!empty($available_dates)): ?>
        <ul class="zip-list">
        <?php foreach ($available_dates as $date): ?>
            <li>
                <?= htmlspecialchars(date("F j, Y", strtotime($date))) ?>
                <form method="post" style="display:inline;">
                    <input type="hidden" name="generate_date" value="<?= htmlspecialchars($date) ?>">
                    <button type="submit">Generate ZIP</button>
                </form>
            </li>
        <?php endforeach; ?>
    </ul>
<?php else: ?>
    <p style="color: #e67e22;">No uploads found yet.</p>
<?php endif; ?>

<?php if ($zip_created): ?>
    <div class="download-link">
        <p><strong>ZIP for <?= htmlspecialchars($generated_date) ?> is ready:</strong></p>
        <a href="/tpst/uploads/<?= basename($zip_file) ?>" target="_blank" style="color: #f1c40f; font-weight: bold;">
            Download ZIP File
        </a>
    </div>
<?php endif; ?>
<div style="margin-top: 60px; text-align: center;">
    <a href="testing.php" style="
        display: inline-block;
        padding: 12px 24px;
        background-color: #3498db;
        color: white;
        text-decoration: none;
        font-weight: bold;
        border-radius: 6px;
        box-shadow: 2px 2px 6px rgba(0,0,0,0.3);
        transition: background-color 0.3s ease;
    " onmouseover="this.style.backgroundColor='#2980b9'" onmouseout="this.style.backgroundColor='#3498db'">
        ← Back to Dashboard
    </a>
</div>



