<?php
session_start();
require_once '../tpst/db.php';

$error = '';
$email = trim($_POST['email_or_username'] ?? '');
$password = $_POST['password'] ?? '';

$stmt = $conn->prepare("SELECT id, subscriber_id, password_hash, is_master FROM AdminTPST WHERE email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$stmt->bind_result($id, $subscriber_id, $hash, $is_master);

if ($stmt->fetch() && password_verify($password, $hash)) {
    $_SESSION['admin_logged_in'] = true;
    $_SESSION['admin_id'] = $id;
    $_SESSION['subscriber_id'] = $subscriber_id;
    $_SESSION['is_master'] = $is_master;
    header("Location: /tpst/testing.php");
    exit;
} else {
    $_SESSION['login_error'] = "Invalid admin credentials.";
    header("Location: login-tpst.php");
    exit;
}

$stmt->close();
