<?php
session_start();
require_once '../tpst/db.php';

$error = '';
$username_or_email = trim($_POST['email_or_username'] ?? '');
$password = $_POST['password'] ?? '';

$stmt = $conn->prepare("SELECT sub_id, password_hash, tier_choice FROM Subscribers WHERE username = ? OR email = ? LIMIT 1");
$stmt->bind_param("ss", $username_or_email, $username_or_email);
$stmt->execute();
$result = $stmt->get_result();

if ($result && $result->num_rows === 1) {
    $row = $result->fetch_assoc();

    if (password_verify($password, $row['password_hash'])) {
        $_SESSION['subscriber_logged_in'] = true;
        $_SESSION['subscriber_id'] = $row['sub_id'];
        $_SESSION['dashboard_type'] = $row['tier_choice'];

        $tier = strtolower(trim($row['tier_choice']));
        if ($tier === 'pro') {
            header("Location: dashboard-pro.php");
        } else {
            header("Location: dashboard-basic.php");
        }
        exit;
    } else {
        $_SESSION['login_error'] = "Invalid password.";
    }
} else {
    $_SESSION['login_error'] = "No account found with that email or username.";
}

$stmt->close();

header("Location: login-tpst.php");
exit;
