<?php
session_start();
require_once __DIR__ . '/tier-config.php';

// ✅ Always allow admin users
if (!empty($_SESSION['admin_logged_in'])) {
    return;
}

// ✅ Check for logged-in subscriber
if (empty($_SESSION['subscriber_id'])) {
    header("Location: /tpst/no-doc-access.php");
    exit;
}

// ✅ Check if subscriber's tier includes document access
$tier = $_SESSION['tier_choice'] ?? 'basic';
$features = $tier_permissions[$tier] ?? $tier_permissions['basic'];

if (empty($features['can_upload_documents'])) {
    header("Location: /tpst/no-doc-access.php");
    exit;
}

