<?php
session_start();

$role = $_POST['role'] ?? '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ($role === 'admin') {
        require 'handle-admin-login.php';
    } elseif ($role === 'subscriber') {
        require 'handle-subscriber-login.php';
    } else {
        $_SESSION['login_error'] = "Please select a valid role.";
        header("Location: login-tpst.php");
        exit;
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Login | TPST</title>
    <style>
        body {
            background: #2c3e50;
            color: white;
            font-family: Arial, sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }
        .box {
            background: rgba(0,0,0,0.75);
            padding: 30px;
            border-radius: 10px;
            width: 400px;
            text-align: center;
            box-shadow: 0 0 10px rgba(0,0,0,0.4);
        }
        input, select {
            width: 100%;
            padding: 12px;
            margin-top: 10px;
            border-radius: 6px;
            border: none;
        }
        button {
            margin-top: 20px;
            width: 100%;
            padding: 12px;
            background: #1abc9c;
            color: white;
            font-weight: bold;
            border: none;
            border-radius: 6px;
            cursor: pointer;
        }
        button:hover {
            background: #16a085;
        }
        .error {
            background-color: #e74c3c;
            color: white;
            margin-top: 15px;
            padding: 10px;
            border-radius: 6px;
        }
        a.forgot {
            display: inline-block;
            margin-top: 15px;
            color: #1abc9c;
            text-decoration: none;
        }
    </style>
</head>
<body>
    <div class="box">
        <h2>Log In</h2>
        <form method="POST">
            <select name="role" required>
            <option value="">-- Choose Role --</option>
            <option value="subscriber">Subscriber</option>
            <option value="admin">Admin</option>
            </select>

            <input type="text" name="email_or_username" placeholder="Email or Username" required>
            <input type="password" name="password" placeholder="Password" required>
            <button type="submit">Log In</button>
        </form>
        <a href="subscriber-forgot-password.php" class="forgot">Forgot Password?</a>

        <?php if (!empty($_SESSION['login_error'])): ?>
            <p class="error"><?= htmlspecialchars($_SESSION['login_error']) ?></p>
            <?php unset($_SESSION['login_error']); ?>
            <?php endif; ?>
        </div>
    </body>
</html>
