<?php

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require_once '../includes/PHPMailer/PHPMailer.php';
require_once '../includes/PHPMailer/SMTP.php';
require_once '../includes/PHPMailer/Exception.php';
require_once '../tpst/db.php'; // assumes $conn is available

function send_email_tpst($to_email, $to_name, $subject, $body_html, $body_plain = '') {
    $mail = new PHPMailer(true);

    try {
        $mail->isSMTP();
        $mail->Host       = 'mail.tandddrivingacademy.com';
        $mail->SMTPAuth   = true;
        $mail->Username   = 'no-reply@tandddrivingacademy.com';
        $mail->Password   = '!ResetPassword1!';
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
        $mail->Port       = 465;

        $mail->setFrom('no-reply@tandddrivingacademy.com', 'T&D Driving Academy');
        $mail->addAddress($to_email, $to_name);
        $mail->addBCC('info@tandddrivingacademy.com');

        $mail->isHTML(true);
        $mail->Subject = $subject;
        $mail->Body    = $body_html;
        $mail->AltBody = $body_plain ?: strip_tags($body_html);

        $mail->send();
        error_log("Email sent to $to_email at " . date("Y-m-d H:i:s") . "\n", 3, __DIR__ . "/../logs/email.log");
        return true;

    } catch (Exception $e) {
        error_log("Email error: " . $mail->ErrorInfo);
        return false;
    }
}

// ✅ Appointment Email WITHOUT tenant logic — for single-use deployment
function sendAppointmentStatusEmail($to_email, $to_name, $test_date, $test_time, $status, $age_group, $appointment_id) {
    $formattedDate = date("F j, Y", strtotime($test_date));
    $formattedTime = date("g:i A", strtotime($test_time));

    // Document checklist by age group
    switch ($age_group) {
        case 'under_18':
            $docs = "<ul>
                <li>DE-964 Certificate (completed)</li>
                <li>Signed Teen IMPACT Certificate</li>
                <li>Valid Learner Permit (on or after hold date)</li>
            </ul>";
            break;
        case '18_24':
            $docs = "<ul>
                <li>ADE-1317 Certificate</li>
                <li>Signed Adult IMPACT Certificate</li>
                <li>Valid Learner Permit</li>
            </ul>";
            break;
        case '25_plus':
            $docs = "<ul>
                <li>Signed Adult IMPACT Certificate</li>
                <li>Valid Learner Permit</li>
            </ul>";
            break;
        default:
            $docs = "<em>Check your original registration for required items.</em>";
    }

    if ($status === 'accepted') {
        $subject = "Driving Test Appointment – Accepted";

        $upload_link_html = "
            <p>Note: You may upload copies of your valid certificates of completion and Driver License here to expedite the paperwork on the morning of the test.</p>
            <p><a href='https://bookings.tandddrivingacademy.com/tpst/upload-documents.php?id=$appointment_id'>Upload My Documents</a></p>
        ";

        $body_html = "
            <p>Dear $to_name,</p>
            <p>Your driving test appointment on <strong>$formattedDate</strong> at <strong>$formattedTime</strong> has been <strong>ACCEPTED</strong>.</p>
            <p>Please bring the following documents to your test:</p>
            $docs
            $upload_link_html
            <p>If you have any questions, reply to this email or call our office.</p>
            <p>– T&D Driving Academy</p>
        ";

    } else {
        $subject = "Driving Test Appointment – Rejected";
        $body_html = "
            <p>Dear $to_name,</p>
            <p>Your driving test appointment on <strong>$formattedDate</strong> at <strong>$formattedTime</strong> has been <strong>REJECTED</strong>.</p>
            <p>This may be due to missing documentation or a scheduling conflict. We'll reach out for clarification and/or to reschedule.</p>
            <p>– T&D Driving Academy</p>
        ";
    }

    send_email_tpst($to_email, $to_name, $subject, $body_html);
}
