<?php
require 'db.php'; // Adjust path as needed
require 'send_email_tpst.php'; // Ensure this points to your PHPMailer wrapper

    require '../includes/PHPMailer.php';
    require '../includes/SMTP.php';
    require '../includes/Exception.php';
    require '../includes/send_email.php';



if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $full_name = trim($_POST['full_name']);
    $email = trim($_POST['email']);
    $phone = trim($_POST['phone']);
    $age_group = $_POST['age_group'];
    $test_date = $_POST['test_date'];
    $test_type = $_POST['test_type'];

    // Validate fields
    if (!$full_name || !$email || !$phone || !$age_group || !$test_date || !$test_type) {
        die("All fields are required.");
    }

    // Check how many are already booked for this date
    $stmt = $conn->prepare("SELECT COUNT(*) FROM tpst_appointments WHERE test_date = ?");
    $stmt->bind_param("s", $test_date);
    $stmt->execute();
    $stmt->bind_result($count);
    $stmt->fetch();
    $stmt->close();

    $test_time = $_POST['test_time'];
    $price = strtotime($test_time) <= strtotime("09:30:00") ? 100 : 125;
    
    // If time is before or equal to 9:30, check cap
    if ($price == 100) {
        $stmt = $conn->prepare("SELECT COUNT(*) FROM tpst_appointments WHERE test_date = ? AND test_time <= '09:30:00'");
        $stmt->bind_param("s", $test_date);
        $stmt->execute();
        $stmt->bind_result($count);
        $stmt->fetch();
        $stmt->close();
    
        if ($count >= 7) {
            die("Morning batch full. Please choose a later time.");
        }
    }

    // Insert the appointment
    $stmt = $conn->prepare("INSERT INTO tpst_appointments (full_name, email, phone, age_group, test_date, test_time, test_type, price) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("sssssssi", $full_name, $email, $phone, $age_group, $test_date, $test_time, $test_type, $price);


    if (!$stmt->execute()) {
        die("Failed to schedule: " . $stmt->error);
    }

    // Prepare checklist email
    $checklist = "";
    if ($age_group === 'under_18') {
        $checklist = "• DE-964 Certificate (with test date)\n• Valid Texas Learner License\n• 30-Hour Log Sheet\n• Parent Log & Completion\n• Vehicle with valid insurance and inspection";
    } elseif ($age_group === '18_24') {
        $checklist = "• ADE-1317 Certificate\n• Texas Learner or Temporary License\n• Impact Texas Young Drivers (ITYD) Certificate\n• Vehicle with valid insurance and inspection";
    } else {
        $checklist = "• Proof of Driver Ed Completion (if applicable)\n• Texas Learner License or Temporary\n• Impact Texas Adult Drivers (ITAD) Certificate\n• Vehicle with valid insurance and inspection";
    }

    $message = "Hello $full_name,\n\nYou are scheduled for a driving test on $test_date at " . date("g:i A", strtotime($test_time)) . ".\n\nTest Fee: $$price\n\nPlease bring the following documents:\n\n$checklist\n\nLate arrivals or reschedules may incur an additional $25 charge.\n\n- T&D Driving Academy";

    send_email_tpst($email, "Your Driving Test Appointment – $test_date", $message);

    echo "<script>alert('Your appointment has been scheduled and a checklist was sent to your email.'); window.location.href='schedule-test.php';</script>";
}
?>
