<?php
session_start();
require '../tpst/db.php';

$token = $_GET['token'] ?? '';
$error = '';
$success = '';

if ($token) {
    $stmt = $conn->prepare("SELECT email, expires_at FROM PasswordResets WHERE token = ? AND user_type = 'subscriber' LIMIT 1");
    $stmt->bind_param("s", $token);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows === 1) {
        $stmt->bind_result($email, $expires_at);
        $stmt->fetch();

        if (strtotime($expires_at) < time()) {
            $error = "❌ This reset link has expired.";
        }
    } else {
        $error = "❌ Invalid or already used reset token.";
    }
    $stmt->close();
} else {
    $error = "❌ No token provided.";
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && empty($error)) {
    $new_password = $_POST['password'] ?? '';
    $confirm = $_POST['confirm'] ?? '';

    if ($new_password !== $confirm) {
        $error = "Passwords do not match.";
    } elseif (strlen($new_password) < 6) {
        $error = "Password must be at least 6 characters.";
    } else {
        $hash = password_hash($new_password, PASSWORD_DEFAULT);

        $stmt = $conn->prepare("UPDATE Subscribers SET password_hash = ? WHERE email = ?");
        $stmt->bind_param("ss", $hash, $email);
        $stmt->execute();

        $stmt = $conn->prepare("DELETE FROM PasswordResets WHERE token = ?");
        $stmt->bind_param("s", $token);
        $stmt->execute();

        $success = "✅ Password updated! <a href='subscriber-login.php' style='color: #1abc9c;'>Log in</a>.";
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Set New Password</title>
    <style>
        body { background: #2c3e50; color: white; font-family: Arial; display: flex; justify-content: center; align-items: center; height: 100vh; }
        .box { background: rgba(0,0,0,0.7); padding: 30px; border-radius: 10px; width: 400px; text-align: center; }
        input[type="password"] { width: 100%; padding: 10px; margin-top: 10px; border-radius: 6px; border: none; }
        button { margin-top: 20px; padding: 12px; width: 100%; background: #1abc9c; border: none; color: white; font-weight: bold; border-radius: 6px; cursor: pointer; }
        .success { color: #2ecc71; margin-top: 15px; }
        .error { color: #e74c3c; margin-top: 15px; }
    </style>
</head>
<body>
<div class="box">
    <h2>Set Your New Password</h2>
    <?php if ($error): ?>
        <p class="error"><?= $error ?></p>
    <?php elseif (!$success): ?>
        <form method="POST">
            <input type="password" name="password" placeholder="New password" required><br>
            <input type="password" name="confirm" placeholder="Confirm password" required><br>
            <button type="submit">Reset Password</button>
        </form>
    <?php endif; ?>
    <?php if ($success): ?>
        <p class="success"><?= $success ?></p>
    <?php endif; ?>
</div>
</body>
</html>
