<?php
session_start();
require_once '../tpst/db.php';

// Simple check: block if not admin
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: admin-login.php");
    exit;
}

// No tier logic needed — admin has full access
$features = [
    'can_upload_documents' => true,
    'can_access_log_testing' => true
];
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <link rel="stylesheet" href="../styles.css">
    <meta charset="UTF-8">
    <title>TPST Admin Control Panel</title>
    <style>
        body {
            font-family: Arial, sans-serif;
           /* background: linear-gradient(to right, #2c3e50, #34495e);*/
            color: white;
            text-align: center;
            padding: 60px 20px;
        }
        h1 {
            margin-bottom: 30px;
        }
        .panel {
            background: rgba(255,255,255,0.1);
            padding: 30px;
            border-radius: 10px;
            display: inline-block;
            box-shadow: 0 0 15px rgba(0,0,0,0.2);
        }
        .panel a {
            display: block;
            margin: 12px auto;
            padding: 14px 22px;
            text-decoration: none;
            color: white;
            font-weight: bold;
            border-radius: 8px;
            background-color: #2980b9;
            box-shadow: 0 2px 6px rgba(0,0,0,0.3);
            transition: background 0.3s;
            width: 280px;
        }
        .panel a:hover {
            background-color: #1f618d;
        }
    </style>
</head>
<body>
<h1 style="color: white; text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.7);">
    TPST Admin Control Panel
</h1>
    <div class="panel">
        <a href="book-test.php" target="_blank">📅 Schedule a Driving Test (Public Form)</a>
        <a href="view-weeks-appointments.php">🕵️ View & Manage Appointments</a>
        <a href="toggle-availability.php">🟢 Toggle Morning Availability</a>
        <?php if ($features['can_access_log_testing']): ?>
            <a href="log-test-results.php" class="btn">Log Testing</a>
        <?php endif; ?>
        <?php if ($features['can_upload_documents']): ?>
            <a href="download-daily-uploads.php">📥 Download Daily Uploads</a>
        <?php endif; ?>
        <a href="../admin-dashboard.php">🔙 Return to Main Dashboard</a>
        <?php if ($features['can_access_log_testing']): ?>
    <form action="delete-all-test-documents.php" method="post" onsubmit="return confirm('⚠️ This will delete ALL uploaded test documents. Are you absolutely sure?');">
        <button type="submit" style="background-color: #e74c3c; color: white; padding: 12px 18px; border: none; border-radius: 6px; font-weight: bold;">
            🧹 Delete All Test Documents
        </button>
    </form>
        <?php endif; ?>
         <a href="calendar-view.php" target="_blank">📆 View Public Calendar</a>
        <a href="/tpst/admin-login.php">Logout</a>
    </div>

</body>
</html>
