<?php
require '../tpst/db.php';
require_once 'send_email_tpst.php'; // Make sure this is included

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = intval($_POST['appointment_id']);
    $new_status = $_POST['new_status'];


    if (in_array($new_status, ['accepted', 'rejected'])) {

        // -- Fetch appointment details first
        $stmt = $conn->prepare("SELECT first_name, last_name, email, test_date, test_time, age_group FROM TestAppointments WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $result = $stmt->get_result();
        $appt = $result->fetch_assoc();
        $stmt->close();

        if (!$appt) {
            exit("Appointment not found.");
        }

        // ✅ Update status
        $stmt = $conn->prepare("UPDATE TestAppointments SET status = ? WHERE id = ?");
        $stmt->bind_param("si", $new_status, $id);
        $stmt->execute();
        $stmt->close();

        // -- Send email after update
        sendAppointmentStatusEmail(
            $appt['email'],
            $appt['first_name'] . ' ' . $appt['last_name'],
            $appt['test_date'],
            $appt['test_time'],
            $new_status,
            $appt['age_group'],
            $id // ✅ This fixes the error
        );

    }
}

header("Location: view-weeks-appointments.php");
exit();

