<?php
require '../tpst/db.php';

$test_id = isset($_GET['id']) ? intval($_GET['id']) : 0;
$error = '';
$success = '';
$upload_successful = false;
$doc_count = 0;

// Confirm test_id is valid
if ($test_id > 0) {
    // Check if any documents already exist for this test appointment
    $stmt = $conn->prepare("SELECT COUNT(*) FROM TestDocuments WHERE test_appointment_id = ?");
    $stmt->bind_param("i", $test_id);
    $stmt->execute();
    $stmt->bind_result($doc_count);
    $stmt->fetch();
    $stmt->close();
} else {
    $error = "⚠️ Invalid upload link.";
}

// Handle file upload
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['documents']) && $test_id > 0) {
    $upload_dir = __DIR__ . "/uploads/applicant/$test_id/";
    if (!is_dir($upload_dir)) {
        mkdir($upload_dir, 0777, true);
    }

    $allowed_types = ['image/jpeg', 'image/png', 'application/pdf'];

    foreach ($_FILES['documents']['name'] as $key => $name) {
        if ($_FILES['documents']['error'][$key] === UPLOAD_ERR_OK) {
            $tmp_name = $_FILES['documents']['tmp_name'][$key];
            $type = $_FILES['documents']['type'][$key];
            $size = $_FILES['documents']['size'][$key];

            if (!in_array($type, $allowed_types)) {
                $error .= "$name is not an allowed file type.<br>";
                continue;
            }

            if ($size > 5 * 1024 * 1024) {
                $error .= "$name is too large (limit 5MB).<br>";
                continue;
            }

            $unique_name = uniqid() . '-' . basename($name);
            $target_path = $upload_dir . $unique_name;

            if (move_uploaded_file($tmp_name, $target_path)) {
                $success .= "$name uploaded successfully.<br>";
                $upload_successful = true;

                $doc_type = 'Other'; // You may replace this with logic if you wish
                $label = basename($name);

                $stmt = $conn->prepare("INSERT INTO TestDocuments (test_appointment_id, doc_type, label, filename) VALUES (?, ?, ?, ?)");
                $stmt->bind_param("isss", $test_id, $doc_type, $label, $unique_name);
                $stmt->execute();
                $stmt->close();
            } else {
                $error .= "Failed to move $name.<br>";
            }
        } else {
    if (empty($name)) {
        $error .= "Empty file slot detected – no file selected.<br>";
    } else {
        $error .= "Error uploading $name.<br>";
    }
}

    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Upload Test Documents</title>
    <style>
        body {
            background: linear-gradient(to right, #2c3e50, #34495e);
            color: white;
            font-family: Arial, sans-serif;
            display: flex;
            justify-content: center;
            align-items: flex-start;
            min-height: 100vh;
            padding: 40px 20px;
        }
        .container {
            background: rgba(0,0,0,0.6);
            padding: 30px;
            border-radius: 12px;
            width: 550px;
            box-shadow: 0 0 12px rgba(0,0,0,0.5);
            text-align: center;
        }
        input[type="file"] {
            margin: 10px 0;
        }
        .success { color: #2ecc71; }
        .error { color: #e74c3c; }
        .file-list a {
            color: #1abc9c;
            font-weight: bold;
            text-decoration: none;
        }
        .file-list a:hover {
            text-decoration: underline;
        }
        .back-button {
            margin-top: 30px;
        }
        .back-button a {
            display: inline-block;
            padding: 10px 18px;
            background-color: #3498db;
            color: white;
            text-decoration: none;
            border-radius: 6px;
            font-weight: bold;
        }
        .back-button a:hover {
            background-color: #2980b9;
        }
    </style>
</head>
<body>
<div class="container">
    <h2>(Optional but advised) Upload Any Supporting Documents for Your Driving Test</h2>

    <?php if (!empty($success)): ?>
        <p class="success"><?= $success ?></p>
    <?php endif; ?>

    <?php if (!empty($error)): ?>
        <p class="error"><?= $error ?></p>
    <?php endif; ?>

    <?php if ($doc_count === 0): ?>
    <form method="post" enctype="multipart/form-data">
        <label for="document1">School Certificate:</label>
        <input type="file" name="documents[]" id="document1"><br>

        <label for="document2">Certificate 2 (Transfer - If applies):</label>
        <input type="file" name="documents[]" id="document2"><br>

        <label for="document3">IMPACT Certificate:</label>
        <input type="file" name="documents[]" id="document3"><br>

        <button type="submit" class="upload-btn">⬆️ Upload Documents</button>
    </form>
    <?php else: ?>
        <p class="success">✅ Documents have already been uploaded. No further action is needed.</p>
    <?php endif; ?>

    <?php if ($test_id > 0): ?>
        <h3 style="margin-top: 40px;">📎 Documents Uploaded for This Test:</h3>
        <ul class="file-list" style="list-style: none; padding: 0;">
            <?php
            $stmt = $conn->prepare("SELECT filename, label FROM TestDocuments WHERE test_appointment_id = ?");
            $stmt->bind_param("i", $test_id);
            $stmt->execute();
            $result = $stmt->get_result();
            while ($doc = $result->fetch_assoc()):
                $file_url = "uploads/applicant/$test_id/" . urlencode($doc['filename']);
            ?>
                <li><a href="<?= htmlspecialchars($file_url) ?>" target="_blank"><?= htmlspecialchars($doc['label']) ?></a></li>
            <?php endwhile;
            $stmt->close(); ?>
        </ul>
    <?php endif; ?>

    <div class="back-button">
        <a href="https://tandddrivingacademy.com">← Back to T&D Driving</a>
    </div>
</div>
</body>
</html>



