<?php
require '../tpst/db.php';

$log_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

// Fetch test log
$stmt = $conn->prepare("
    SELECT tl.*, ta.full_name, ta.email, ta.test_date AS appt_date
    FROM TestLogs tl
    JOIN TestAppointments ta ON tl.appointment_id = ta.id
    WHERE tl.id = ?
");
$stmt->bind_param("i", $log_id);
$stmt->execute();
$result = $stmt->get_result();
$log = $result->fetch_assoc();
$stmt->close();

if (!$log) {
    die("Test log not found.");
}

// Fetch documents
$stmt = $conn->prepare("SELECT doc_type, filename FROM TestDocuments WHERE test_log_id = ?");
$stmt->bind_param("i", $log_id);
$stmt->execute();
$docs = $stmt->get_result();
$documents = [];
while ($row = $docs->fetch_assoc()) {
    $documents[$row['doc_type']][] = $row['filename'];
}
$stmt->close();

$folderPath = "test-packets/" . date("Ymd", strtotime($log['test_date'])) . "-appt-{$log['appointment_id']}-log-{$log_id}/";
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Test Packet Viewer</title>
    <style>
        body { font-family: Arial; background: #f7f7f7; padding: 30px; }
        .container { background: #fff; border-radius: 10px; padding: 30px; max-width: 800px; margin: auto; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
        h2, h3 { margin-top: 0; }
        ul { list-style: none; padding-left: 0; }
        li { margin-bottom: 5px; }
        a.download-link {
            background: #3498db;
            color: white;
            padding: 6px 12px;
            border-radius: 5px;
            text-decoration: none;
            margin-left: 10px;
        }
        .back-btn {
            display: inline-block;
            margin-bottom: 20px;
            padding: 8px 16px;
            background-color: #2ecc71;
            color: white;
            text-decoration: none;
            border-radius: 6px;
        }
    </style>
</head>
<body>
    <div class="container">
        <a href="testing.php" class="back-btn">← Back to Control Panel</a>
        <h2>Test Packet for <?= htmlspecialchars($log['full_name']) ?></h2>

        <p><strong>Appointment Date:</strong> <?= htmlspecialchars($log['appt_date']) ?></p>
        <p><strong>Test Date:</strong> <?= htmlspecialchars($log['test_date']) ?></p>
        <p><strong>Result:</strong> <?= ucfirst($log['result']) ?></p>
        <p><strong>Examiner Notes:</strong><br><?= nl2br(htmlspecialchars($log['examiner_notes'] ?? '')) ?></p>

        <h3>Uploaded Documents</h3>
        <?php if (empty($documents)): ?>
            <p><em>No documents uploaded.</em></p>
        <?php else: ?>
            <?php foreach ($documents as $type => $files): ?>
                <h4><?= $type ?></h4>
                <ul>
                    <?php foreach ($files as $file): ?>
                        <li>
                            <?= htmlspecialchars($file ?? '', ENT_QUOTES, 'UTF-8') ?>
                            <a class="download-link" href="<?= $folderPath . $file ?>" download>Download</a>
                        </li>
                    <?php endforeach; ?>
                </ul>
            <?php endforeach; ?>
            <div style="margin-top: 30px;">
                            <a href="download-packet.php?log_id=<?= $log_id ?>" class="download-link" style="background-color: #f39c12;">
                                📦 Download Full Packet (.zip)
                            </a>
                            </div>
        <?php endif; ?>
    </div>
</body>
</html>
