<?php
// admin-invoice.php
session_start();
require 'db.php';

function safe($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

$student = null;
$nos     = [];
$total   = 0.00;

if (isset($_GET['student_id'])) {
    $sid = (int)$_GET['student_id'];

    // student
    $s = $conn->prepare("SELECT id, first_name, last_name, email, permit_number, section_code FROM Students WHERE id=?");
    $s->bind_param('i', $sid);
    $s->execute();
    $student = $s->get_result()->fetch_assoc();
    $s->close();

    if ($student) {
        // itemize no-shows with fees
        $q = $conn->prepare("SELECT date, fee, reason FROM NoShows WHERE student_id=? AND fee IS NOT NULL ORDER BY date ASC");
        $q->bind_param('i', $sid);
        $q->execute();
        $r = $q->get_result();
        while ($row = $r->fetch_assoc()) {
            $row['fee'] = (float)$row['fee'];
            $nos[] = $row;
            $total += $row['fee'];
        }
        $q->close();
    }
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Invoice • Balance Due</title>
  <style>
    :root{
      --bg:#0f2e5e; --fg:#ffffff; --card:#ffffff; --ink:#0a1930; --muted:#6b7c97; --accent:#58b1ff;
    }
    *{box-sizing:border-box}
    body{margin:24px; font-family:system-ui,-apple-system,Segoe UI,Roboto,Arial,sans-serif; background:linear-gradient(180deg,#0a1930, #0f2e5e); color:var(--fg)}
    .wrap{max-width:900px;margin:0 auto}
    .nav{display:flex;justify-content:space-between;align-items:center;margin-bottom:14px}
    .btn{background:linear-gradient(180deg,var(--accent),#3da6ff); color:#00132a; padding:.55rem .9rem; border:none; border-radius:10px; font-weight:700; cursor:pointer; text-decoration:none; display:inline-block}
    .card{background:var(--card); color:var(--ink); border-radius:14px; padding:20px; box-shadow:0 8px 30px rgba(0,0,0,.25)}
    h1{margin:0 0 6px}
    table{width:100%; border-collapse:collapse; margin-top:12px}
    th,td{padding:10px; border-bottom:1px solid #e6ecf5; vertical-align:top}
    th{text-align:left; color:#274264}
    tfoot td{font-weight:800}
    .muted{color:var(--muted)}
    .right{text-align:right}
    .print-hint{margin-top:8px; color:#cfe2ff}
    @media print{
      body{background:#fff; color:#000}
      .nav, .print-hint{display:none}
      .card{box-shadow:none; border:1px solid #ddd}
    }
  </style>
</head>
<body>
<div class="wrap">
  <div class="nav">
    <a href="admin-dashboard.php" class="btn">← Admin Dashboard</a>
    <?php if($student): ?>
      <button onclick="window.print()" class="btn">Print / Save PDF</button>
    <?php endif; ?>
  </div>

  <?php if(!$student): ?>
    <div class="card">
      <h1>Create Invoice</h1>
      <p class="muted">Enter a Student ID to generate an itemized no-show invoice.</p>
      <form method="get" style="display:flex;gap:8px;align-items:center;margin-top:10px">
        <input type="number" name="student_id" placeholder="Student ID" required
               style="padding:.6rem .8rem; border:1px solid #cfd8e3; border-radius:10px; flex:0 0 180px">
        <button class="btn">Generate</button>
      </form>
      <p class="print-hint">Tip: you can also link here like <code>admin-invoice.php?student_id=123</code>.</p>
    </div>
  <?php else: ?>
    <div class="card">
      <div style="display:flex;justify-content:space-between;align-items:flex-start;gap:16px">
        <div>
          <h1>Invoice: Balance Due</h1>
          <div class="muted">Invoice #NS-<?= date('Ymd') ?>-<?= (int)$student['id'] ?></div>
          <div class="muted">Issued: <?= safe(date('M j, Y')) ?></div>
        </div>
        <div style="text-align:right">
          <div style="font-weight:800;font-size:1.15rem">T&amp;D Driving Academy</div>
          <div class="muted">bookings.tandddrivingacademy.com</div>
          <div class="muted">info@tandddrivingacademy.com</div>
        </div>
      </div>

      <hr style="border:none;border-top:1px solid #e6ecf5;margin:14px 0">

      <div style="display:flex;justify-content:space-between;gap:16px;flex-wrap:wrap">
        <div>
          <div class="muted">Bill To</div>
          <div style="font-weight:700"><?= safe($student['first_name'].' '.$student['last_name']) ?></div>
          <div class="muted"><?= safe($student['email'] ?: '') ?></div>
          <?php if(!empty($student['permit_number'])): ?>
            <div class="muted">Permit #: <?= safe($student['permit_number']) ?></div>
          <?php endif; ?>
          <?php if(!empty($student['section_code'])): ?>
            <div class="muted">Section: <?= safe($student['section_code']) ?></div>
          <?php endif; ?>
        </div>
        <div class="right">
          <div class="muted">Summary</div>
          <div style="font-size:1.35rem;font-weight:800">$<?= number_format($total, 2) ?></div>
        </div>
      </div>

      <table>
        <thead>
          <tr>
            <th style="width:30%">Date</th>
            <th style="width:50%">Description</th>
            <th class="right" style="width:20%">Amount</th>
          </tr>
        </thead>
        <tbody>
          <?php if(empty($nos)): ?>
            <tr><td colspan="3" class="muted">No no-show fees on record.</td></tr>
          <?php else: foreach($nos as $row): ?>
            <tr>
              <td><?= safe(date('M j, Y', strtotime($row['date']))) ?></td>
              <td>No-show fee<?= $row['reason'] ? ' — '.safe($row['reason']) : '' ?></td>
              <td class="right">$<?= number_format($row['fee'],2) ?></td>
            </tr>
          <?php endforeach; endif; ?>
        </tbody>
        <tfoot>
          <tr>
            <td></td>
            <td class="right">Total Due</td>
            <td class="right">$<?= number_format($total,2) ?></td>
          </tr>
        </tfoot>
      </table>

      <p class="muted" style="margin-top:12px">
        If you need to cancel a booking, please email before noon of the day of your lesson.
      </p>
    </div>
  <?php endif; ?>
</div>
</body>
</html>
