<?php
session_start();
require 'db.php';

if (!isset($_SESSION['instructor_id'])) {
    header("Location: instructor-login.php");
    exit();
}

$instructor_id = $_SESSION['instructor_id'];

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $slot_date = $_POST['slot_date'] ?? '';
    $start_time = $_POST['start_time'] ?? '';
    $end_time = $_POST['end_time'] ?? '';

    $stmt = $conn->prepare("DELETE FROM InstructorAvailability WHERE instructor_id = ? AND available_date = ? AND start_time = ? AND end_time = ?");
    $stmt->bind_param("isss", $instructor_id, $slot_date, $start_time, $end_time);
    $stmt->execute();
    $stmt->close();
}

header("Location: instructor-availability.php");
exit();
?>

