<?php
session_start();
require 'db.php';

if (!isset($_SESSION['admin_id'])) {
    header("Location: admin-login.php");
    exit();
}

$query = $conn->query("
    SELECT 
        cu.updated_at,
        s.first_name AS student_first,
        s.last_name AS student_last,
        a.name AS admin_name,
        cu.field_changed,
        cu.old_value,
        cu.new_value
    FROM 
        CertificateUpdates cu
    JOIN 
        Students s ON cu.student_id = s.id
    JOIN 
        admins a ON cu.admin_id = a.id
    ORDER BY 
        cu.updated_at DESC
");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Certificate Update Log</title>
    <link rel="stylesheet" href="styles.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            padding: 30px;
            background: #f7f7f7;
        }

        h2 {
            text-align: center;
            margin-bottom: 30px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            background: white;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }

        th, td {
            padding: 12px 10px;
            border-bottom: 1px solid #ccc;
            text-align: left;
            font-size: 0.95em;
        }

        th {
            background-color: #007bff;
            color: white;
        }

        tr:hover {
            background-color: #f1f1f1;
        }

        .dashboard-link {
            display: inline-block;
            margin-top: 20px;
            background: #007bff;
            color: white;
            padding: 10px 16px;
            border-radius: 5px;
            text-decoration: none;
        }
    </style>
</head>
<body>
<h2>Certificate Update History Log</h2>

<table>
    <thead>
        <tr>
            <th>Date/Time</th>
            <th>Student</th>
            <th>Field Changed</th>
            <th>Old Value</th>
            <th>New Value</th>
            <th>Changed By</th>
        </tr>
    </thead>
    <tbody>
        <?php while ($row = $query->fetch_assoc()): ?>
            <tr>
                <td><?= htmlspecialchars($row['updated_at']) ?></td>
                <td><?= htmlspecialchars($row['student_last']) ?>, <?= htmlspecialchars($row['student_first']) ?></td>
                <td><?= htmlspecialchars($row['field_changed']) ?></td>
                <td><?= htmlspecialchars($row['old_value']) ?></td>
                <td><?= htmlspecialchars($row['new_value']) ?></td>
                <td><?= htmlspecialchars($row['admin_name']) ?></td>
            </tr>
        <?php endwhile; ?>
    </tbody>
</table>

<a href="admin-dashboard.php" class="dashboard-link">Return to Dashboard</a>
</body>
</html>
