<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Registration Received</title>
    <style>
        body {
            margin: 0;
            font-family: 'Segoe UI', sans-serif;
            background: #f4f4f4;
            color: #333;
            text-align: center;
        }
        .hero {
            background-image: url('images/mustang-banner.jpg'); /* Replace with your actual path */
            background-size: cover;
            background-position: center;
            height: 300px;
        }
        .content {
            padding: 40px 20px;
        }
        .speedometer {
            width: 150px;
            height: 150px;
            margin: 0 auto 20px;
        }
        .needle {
            transform-origin: center;
            animation: rotateNeedle 2s ease-out forwards;
        }
        @keyframes rotateNeedle {
            from {
                transform: rotate(-90deg);
            }
            to {
                transform: rotate(45deg);
            }
        }
        h1 {
            font-size: 2em;
            color: #222;
        }
        p {
            font-size: 1.2em;
            margin-top: 10px;
        }
        .button {
            margin-top: 30px;
            padding: 12px 24px;
            background-color: #e74c3c;
            color: white;
            border: none;
            border-radius: 6px;
            font-size: 1em;
            cursor: pointer;
            text-decoration: none;
        }
        .button:hover {
            background-color: #c0392b;
        }
    </style>
</head>
<body>
    <div class="hero"></div>
    <div class="content">
        <!-- Animated Speedometer -->
        <svg class="speedometer" viewBox="0 0 100 100">
            <circle cx="50" cy="50" r="45" stroke="#ccc" stroke-width="5" fill="none"/>
            <path d="M50 50 L50 10" stroke="#e74c3c" stroke-width="4" class="needle"/>
            <circle cx="50" cy="50" r="4" fill="#333"/>
        </svg>

        <h1>Thank You for Starting the Registration Process!</h1>
        <p>You're one mile closer to becoming a licensed driver!</p>
        <a href="https://tandddrivingacademy.com" class="button">Return to Home</a>
    </div>
</body>
</html>

