<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Student Registration Contract</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: #f4f4f4;
            padding: 40px;
            line-height: 1.6;
        }

        .container {
            background: white;
            max-width: 700px;
            margin: auto;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 0 15px rgba(0,0,0,0.1);
        }

        h2 {
            text-align: center;
            margin-bottom: 20px;
        }

        .instructions {
            background: #eaf4ff;
            padding: 15px;
            border-left: 5px solid #007bff;
            margin-bottom: 25px;
        }

        .download-section {
            display: flex;
            flex-direction: column;
            gap: 20px;
        }

        .btn-download {
            background: #007bff;
            color: white;
            text-align: center;
            padding: 12px;
            text-decoration: none;
            border-radius: 5px;
            font-weight: bold;
        }

        .btn-download:hover {
            background: #0056b3;
        }

        .footer-note {
            margin-top: 30px;
            font-size: 0.95em;
            color: #666;
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Student Registration Contract</h2>

        <div class="instructions">
            <p>Please download and complete the registration contract prior to your student's first day. This form is required and helps speed up the check-in process.</p>
            <ul>
                <li>Use the <strong>fillable PDF</strong> on a desktop with Adobe Acrobat to type in your information.</li>
                <li>Alternatively, print the <strong>preview-only version</strong> to complete by hand.</li>
                <li>Bring the signed contract to your scheduled registration appointment or class start date.</li>
            </ul>
        </div>

        <div class="contract-downloads">
    <h3>Download Student Contract</h3>
    <p>Please complete and bring one of the following to your scheduled registration appointment:</p>
    <ul>
        <li><a class="btn-download" href="/assets/TDStudentContract_Fillable.pdf" target="_blank">Download Fillable Contract (type before printing)</a></li>
        <li><a class="btn-download" href="/assets/TDStudentContract_Printable.pdf" target="_blank">Download Printable Contract (fill out by hand)</a></li>
    </ul>
</div>


        <div class="footer-note">
            If you need assistance or prefer a Spanish version, please contact our office directly.
        </div>
    </div>
</body>
</html>
