<?php
session_start();
require 'db.php';

require_once 'vendor/autoload.php';
require_once 'includes/PHPMailer/Exception.php';
require_once 'includes/PHPMailer/PHPMailer.php';
require_once 'includes/PHPMailer/SMTP.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

$success = $_SESSION['student_success'] ?? "";
$error = $_SESSION['student_error'] ?? "";

unset($_SESSION['student_success'], $_SESSION['student_error']);

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $first_name = trim($_POST['first_name']);
    $last_name = trim($_POST['last_name']);
    $email = trim($_POST['email']);
    $ssn_last4 = trim($_POST['ssn_last4']);
    $permit_number = trim($_POST['permit_number'] ?? '');
    $permit_received_at = !empty($_POST['permit_received_at']) ? $_POST['permit_received_at'] : null;
    $section_code = trim($_POST['section_code']);

    // 1. Auto-generate password
    $password_raw = strtolower(substr($first_name, 0, 1) . $last_name . $ssn_last4);
    $password_hashed = password_hash($password_raw, PASSWORD_DEFAULT);

    // 2. Generate confirmation token
    $pw_token_confirm = bin2hex(random_bytes(16));

    // 3. Check for duplicate
    $check = $conn->prepare("SELECT id FROM Students WHERE email = ?");
    $check->bind_param("s", $email);
    $check->execute();
    $check->store_result();

    if ($check->num_rows > 0) {
        $_SESSION['student_error'] = "This email is already registered.";
        $check->close();
        header("Location: create-student.php");
        exit();
    }
    $check->close();

    // 4. Insert new student
    $stmt = $conn->prepare("INSERT INTO Students 
    (first_name, last_name, email, ssn_last4, section_code, password, pw_token_confirm, is_confirmed)
    VALUES (?, ?, ?, ?, ?, ?, ?, 0)");
    $stmt->bind_param("sssssss", $first_name, $last_name, $email, $ssn_last4, $section_code, $password_hashed, $pw_token_confirm);

    if ($stmt->execute()) {
        // 5. Send email
        
        $mail = new PHPMailer(true);
        $mail->CharSet = 'UTF-8';
        
        try {
            $mail->isSMTP();
            $mail->Host = 'mail.tandddrivingacademy.com';
            $mail->SMTPAuth = true;
            $mail->Username = 'no-reply@tandddrivingacademy.com';
            $mail->Password = '!ResetPassword1!';
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
            $mail->Port = 465;

            $mail->setFrom('no-reply@tandddrivingacademy.com', 'T&D Driving Academy');
            $mail->addAddress($email, "$first_name $last_name");

            $mail->isHTML(true);
            $mail->Subject = 'Welcome to T&D Driving Academy – Confirm Your Account';

            $confirmation_link = "https://bookings.tandddrivingacademy.com/confirm-account.php?pw_token_confirm=" . urlencode($pw_token_confirm);

            $mail->Body = "
                <p>Hello <strong>$first_name</strong>,</p>
                <p>Welcome to T&D Driving Academy! We've created your student account.</p>
                <p><strong>Login Email:</strong> $email<br>
                <strong>Temporary Password:</strong> $password_raw</p>
                <p><a href='$confirmation_link'>Click here to confirm your account and access the dashboard</a></p>
                <p>After confirmation, you may log in and reset your password anytime.</p>
                <p>Best regards,<br>T&D Driving Academy</p>
            ";

            $mail->send();

            $_SESSION['student_success'] = "Student added and confirmation email sent!";
        } catch (Exception $e) {
            error_log("Email error: {$mail->ErrorInfo}");
            $_SESSION['student_error'] = "Student added but email could not be sent.";
        }

    } else {
        $_SESSION['student_error'] = "Error: " . $stmt->error;
    }

    $stmt->close();
    header("Location: create-student.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <link rel="stylesheet" href="styles.css">
    <meta charset="UTF-8">
    <title>Create Student</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            /* background: #f7f7f7; */
            height: 100vh;
            margin: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            margin-top: 100;
        }
        .container {
            background: rgba(255,255,255,0.80);
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 0 15px rgba(0,0,0,0.2);
            width: 360px;
            text-align: center;
            transform: translateY(125px); /* or however far down you want */
        }

        input, select {
            width: 100%;
            padding: 10px;
            margin-bottom: 15px;
        }
        input[type="submit"], button {
            background-color: #ff6c2c;
            color: white;
            border: none;
            cursor: pointer;
            padding: 10px;
            width: 48%;
            margin: 5px 1%;
            border-radius: 5px;
        }
        .success { color: green; margin-bottom: 15px; }
        .error { color: red; margin-bottom: 15px; }
    </style>
</head>
<body>
<div class="container">
    <h2>Create Student</h2>

    <?php if ($success): ?><p class="success"><?= $success ?></p><?php endif; ?>
    <?php if ($error): ?><p class="error"><?= $error ?></p><?php endif; ?>

    <?php if (!$success): ?>
    <form method="post">
        <input type="text" name="first_name" placeholder="First Name" required>
        <input type="text" name="last_name" placeholder="Last Name" required>
        <input type="email" name="email" placeholder="Email Address" required>
        <input type="text" name="ssn_last4" placeholder="Last 4 of SSN" maxlength="4" pattern="\d{4}" title="Enter exactly 4 digits" required>
        <p style="font-size: 0.9em; color: #665;">
        A temporary password will be generated automatically based on the student's name and last 4 digits of their SSN.
            </p>
        <input type="text" name="permit_number" placeholder="Permit Number (optional)">
        <input type="date" name="permit_received_at" placeholder="Permit Received Date">
        <input type="text" name="section_code" placeholder="Section Code (e.g., T.05.2025 or A.00.2025)" pattern="[TA]\.\d{2}\.\d{4}" title="Format: T.01.2025 or A.00.2025" required>
        <input type="submit" value="Create Student">
    </form>
    <?php else: ?>
    <form method="get">
        <button type="submit">Add Another Student</button>
        <button type="button" onclick="window.location.href='admin-dashboard.php'">Done</button>
    </form>
    <?php endif; ?>
    <div style="text-align: center; margin-top: 30px;">
    <a href="admin-dashboard.php" style="
        display: inline-block;
        padding: 12px 24px;
        background-color: #007bff;
        color: white;
        text-decoration: none;
        border-radius: 6px;
        font-weight: bold;
        box-shadow: 0 2px 5px rgba(0,0,0,0.2);
        transition: background-color 0.3s;
    ">
        Back to Dashboard
    </a>
</div>
</div>
</body>
</html>



