<?php
// === Required Includes ===

require_once __DIR__ . '/vendor/setasign/fpdf/fpdf.php';
require_once __DIR__ . '/vendor/autoload.php';

use setasign\Fpdi\Fpdi;

// === Configurable Parameters ===
$start = 679006;          // Starting control number
$count = 50;                // How many certificates to generate
$templatePath = 'assets/de964-template.pdf';  // Two-page DE-964 template
$outputDir = __DIR__ . '/de964_output/';
$fontSize = 12;
$font = 'Helvetica';
$page1_X = 499;
$page1_Y = 40;
$page2_X = 499;  // Same X
$page2_Y = 43;   // Adjust Y slightly downward

// === Create Output Directory If It Doesn't Exist ===
if (!file_exists($outputDir)) {
    mkdir($outputDir, 0777, true);
}

// === Generate Each Certificate ===
for ($i = 0; $i < $count; $i++) {
    $controlNumber = 'DEE-' . ($start + $i);

    $pdf = new Fpdi('P', 'pt', 'Letter');
    $pdf->setSourceFile($templatePath);

        // === PAGE 1 ===
    $pdf->AddPage();
    $tpl1 = $pdf->importPage(1);
    $pdf->useTemplate($tpl1, 0, 0, 612, 792);
    $pdf->SetAutoPageBreak(false); // prevents template influence
    $pdf->SetFont($font, '', $fontSize);
    $pdf->SetTextColor(255, 0, 0);
    $pdf->SetXY($page1_X, $page1_Y);
    $pdf->Write(0, $controlNumber);
    
        // === PAGE 2 ===
    $pdf->AddPage();
    $tpl2 = $pdf->importPage(2);
    $pdf->useTemplate($tpl2, 0, 0, 612, 792);
    $pdf->SetAutoPageBreak(false);
    $pdf->SetXY($page2_X, $page2_Y);
    $pdf->Write(0, $controlNumber);

    // === Save Output ===
    $outputPath = $outputDir . "DE964_$controlNumber.pdf";
    $pdf->Output('F', $outputPath);
}

// Optional: Notify or log success
echo "✅ Successfully generated $count DE-964 certificates in: $outputDir\n";
